/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.internal.opencensus;

import io.dapr.internal.opencensus.BigendianEncoding;
import io.dapr.internal.opencensus.Utils;
import javax.annotation.concurrent.Immutable;

@Immutable
final class SpanId
implements Comparable<SpanId> {
    public static final int SIZE = 8;
    private static final int BASE16_SIZE = 16;
    private static final long INVALID_ID = 0L;
    private final long id;

    private SpanId(long id) {
        this.id = id;
    }

    static SpanId fromLowerBase16(CharSequence src, int srcOffset) {
        Utils.checkNotNull(src, "src");
        return new SpanId(BigendianEncoding.longFromBase16String(src, srcOffset));
    }

    byte[] getBytes() {
        byte[] bytes = new byte[8];
        BigendianEncoding.longToByteArray(this.id, bytes, 0);
        return bytes;
    }

    void copyBytesTo(byte[] dest, int destOffset) {
        BigendianEncoding.longToByteArray(this.id, dest, destOffset);
    }

    void copyLowerBase16To(char[] dest, int destOffset) {
        BigendianEncoding.longToBase16String(this.id, dest, destOffset);
    }

    boolean isValid() {
        return this.id != 0L;
    }

    String toLowerBase16() {
        char[] chars = new char[16];
        this.copyLowerBase16To(chars, 0);
        return new String(chars);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SpanId)) {
            return false;
        }
        SpanId that = (SpanId)obj;
        return this.id == that.id;
    }

    public int hashCode() {
        return (int)(this.id ^ this.id >>> 32);
    }

    public String toString() {
        return "SpanId{spanId=" + this.toLowerBase16() + "}";
    }

    @Override
    public int compareTo(SpanId that) {
        return this.id < that.id ? -1 : (this.id == that.id ? 0 : 1);
    }
}

