/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.utils;

import java.time.Duration;

public class DurationUtils {
    public static Duration convertDurationFromDaprFormat(String valueString) {
        int hourIndex = valueString.indexOf(104);
        int minuteIndex = valueString.indexOf(109);
        int secondIndex = valueString.indexOf(115);
        int milliIndex = valueString.indexOf("ms");
        String hoursSpan = valueString.substring(0, hourIndex);
        int hours = Integer.parseInt(hoursSpan);
        int days = hours / 24;
        hours %= 24;
        String minutesSpan = valueString.substring(hourIndex + 1, minuteIndex);
        int minutes = Integer.parseInt(minutesSpan);
        String secondsSpan = valueString.substring(minuteIndex + 1, secondIndex);
        int seconds = Integer.parseInt(secondsSpan);
        String millisecondsSpan = valueString.substring(secondIndex + 1, milliIndex);
        int milliseconds = Integer.parseInt(millisecondsSpan);
        return Duration.ZERO.plusDays(days).plusHours(hours).plusMinutes(minutes).plusSeconds(seconds).plusMillis(milliseconds);
    }

    public static String convertDurationToDaprFormat(Duration value) {
        String stringValue = "";
        if (value == Duration.ZERO || value.compareTo(Duration.ZERO) == 1) {
            long hours = DurationUtils.getDaysPart(value) * 24L + DurationUtils.getHoursPart(value);
            StringBuilder sb = new StringBuilder();
            sb.append(hours);
            sb.append("h");
            sb.append(DurationUtils.getMinutesPart(value));
            sb.append("m");
            sb.append(DurationUtils.getSecondsPart(value));
            sb.append("s");
            sb.append(DurationUtils.getMilliSecondsPart(value));
            sb.append("ms");
            return sb.toString();
        }
        return stringValue;
    }

    static long getDaysPart(Duration d) {
        long t = d.getSeconds() / 60L / 60L / 24L;
        return t;
    }

    static long getHoursPart(Duration d) {
        long u = d.getSeconds() / 60L / 60L % 24L;
        return u;
    }

    static long getMinutesPart(Duration d) {
        long u = d.getSeconds() / 60L % 60L;
        return u;
    }

    static long getSecondsPart(Duration d) {
        long u = d.getSeconds() % 60L;
        return u;
    }

    static long getMilliSecondsPart(Duration d) {
        long u = d.toMillis() % 1000L;
        return u;
    }
}

