/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.utils;

class Retry {
    private static final long RETRY_WAIT_MILLISECONDS = 1000L;

    private Retry() {
    }

    static void callWithRetry(Runnable function, long retryTimeoutMilliseconds) throws InterruptedException {
        long started = System.currentTimeMillis();
        while (true) {
            Object exception;
            try {
                function.run();
                return;
            }
            catch (Exception e) {
                exception = e;
            }
            catch (AssertionError e) {
                exception = e;
            }
            long elapsed = System.currentTimeMillis() - started;
            if (elapsed >= retryTimeoutMilliseconds) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new RuntimeException((Throwable)exception);
            }
            long remaining = retryTimeoutMilliseconds - elapsed;
            Thread.sleep(Math.min(remaining, 1000L));
        }
    }
}

