/*
 * Decompiled with CFR 0.152.
 */
package io.github.a2ap.core.client.impl;

import io.github.a2ap.core.client.CardResolver;
import io.github.a2ap.core.model.AgentCard;
import io.github.a2ap.core.util.JsonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.netty.http.client.HttpClient;

public class HttpCardResolver
implements CardResolver {
    private static final Logger log = LoggerFactory.getLogger(HttpCardResolver.class);
    private final String baseUrl;
    private final HttpClient httpClient;

    public HttpCardResolver(String baseUrl) {
        this.baseUrl = baseUrl;
        this.httpClient = HttpClient.create().baseUrl(this.baseUrl);
    }

    @Override
    public AgentCard resolveCard() {
        log.info("Retrieve agent card to {}", (Object)this.baseUrl);
        try {
            AgentCard responseCard = (AgentCard)((HttpClient.ResponseReceiver)this.httpClient.get().uri("/.well-known/agent.json")).responseContent().aggregate().asString().map(data -> JsonUtil.fromJson(data, AgentCard.class)).block();
            log.info("Retrieve agent card {} successfully. Info: {}", (Object)this.baseUrl, (Object)responseCard);
            return responseCard;
        }
        catch (Exception e) {
            log.error("Error sending task to {}: {}", new Object[]{this.baseUrl, e.getMessage(), e});
            return null;
        }
    }
}

