/*
 * Decompiled with CFR 0.152.
 */
package io.github.a2ap.core.exception;

import java.util.Objects;

public class A2AError
extends RuntimeException {
    public static final int INVALID_PARAMS = -32602;
    public static final int METHOD_NOT_FOUND = -32601;
    public static final int TASK_NOT_FOUND = 1001;
    public static final int TASK_CANCELLED = 1002;
    public static final int AGENT_EXECUTION_ERROR = 1003;
    public static final int AUTHENTICATION_ERROR = 1004;
    public static final int AUTHORIZATION_ERROR = 1005;
    private int code;
    private Object data;
    private String taskId;

    public A2AError() {
    }

    public A2AError(String message) {
        super(message);
    }

    public A2AError(String message, Throwable cause) {
        super(message, cause);
    }

    public A2AError(String message, int code, Object data, String taskId) {
        super(message);
        this.code = code;
        this.data = data;
        this.taskId = taskId;
    }

    public A2AError(String message, int code, Object data) {
        super(message);
        this.code = code;
        this.data = data;
    }

    public A2AError(String message, Throwable cause, int code, Object data, String taskId) {
        super(message, cause);
        this.code = code;
        this.data = data;
        this.taskId = taskId;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        A2AError a2AError = (A2AError)o;
        return this.code == a2AError.code && Objects.equals(this.data, a2AError.data) && Objects.equals(this.taskId, a2AError.taskId) && Objects.equals(this.getMessage(), a2AError.getMessage());
    }

    public int hashCode() {
        return Objects.hash(this.code, this.data, this.taskId, this.getMessage());
    }

    @Override
    public String toString() {
        return "A2AError{code=" + this.code + ", data=" + this.data + ", taskId='" + this.taskId + "', message='" + this.getMessage() + "'}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String message;
        private int code;
        private Object data;
        private String taskId;
        private Throwable cause;

        private Builder() {
        }

        public Builder message(String message) {
            this.message = message;
            return this;
        }

        public Builder code(int code) {
            this.code = code;
            return this;
        }

        public Builder data(Object data) {
            this.data = data;
            return this;
        }

        public Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public Builder cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        public A2AError build() {
            if (this.cause != null) {
                return new A2AError(this.message, this.cause, this.code, this.data, this.taskId);
            }
            return new A2AError(this.message, this.code, this.data, this.taskId);
        }
    }
}

