/*
 * Decompiled with CFR 0.152.
 */
package io.github.a2ap.core.jsonrpc;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.a2ap.core.jsonrpc.JSONRPCError;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class JSONRPCResponse {
    @JsonProperty(value="jsonrpc")
    private final String jsonrpc = "2.0";
    @JsonProperty(value="result")
    private Object result;
    @JsonProperty(value="error")
    private JSONRPCError error;
    @JsonProperty(value="id")
    private String id;

    public JSONRPCResponse() {
    }

    public JSONRPCResponse(String id) {
        this.id = id;
    }

    public JSONRPCResponse(String id, Object result) {
        this.id = id;
        this.result = result;
    }

    public JSONRPCResponse(String id, JSONRPCError error) {
        this.id = id;
        this.error = error;
    }

    public String getJsonrpc() {
        return "2.0";
    }

    public Object getResult() {
        return this.result;
    }

    public void setResult(Object result) {
        this.result = result;
        this.error = null;
    }

    public JSONRPCError getError() {
        return this.error;
    }

    public void setError(JSONRPCError error) {
        this.error = error;
        this.result = null;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JSONRPCResponse that = (JSONRPCResponse)o;
        return Objects.equals("2.0", that.jsonrpc) && Objects.equals(this.result, that.result) && Objects.equals(this.error, that.error) && Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash("2.0", this.result, this.error, this.id);
    }

    public String toString() {
        return "JSONRPCResponse{jsonrpc='2.0', result=" + this.result + ", error=" + this.error + ", id='" + this.id + "'}";
    }
}

