/*
 * Decompiled with CFR 0.152.
 */
package io.github.a2ap.core.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class AgentCapabilities {
    private boolean streaming = false;
    private boolean pushNotifications = false;
    private boolean stateTransitionHistory = false;

    public AgentCapabilities() {
    }

    public AgentCapabilities(boolean streaming, boolean pushNotifications, boolean stateTransitionHistory) {
        this.streaming = streaming;
        this.pushNotifications = pushNotifications;
        this.stateTransitionHistory = stateTransitionHistory;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean isStreaming() {
        return this.streaming;
    }

    public void setStreaming(boolean streaming) {
        this.streaming = streaming;
    }

    public boolean isPushNotifications() {
        return this.pushNotifications;
    }

    public void setPushNotifications(boolean pushNotifications) {
        this.pushNotifications = pushNotifications;
    }

    public boolean isStateTransitionHistory() {
        return this.stateTransitionHistory;
    }

    public void setStateTransitionHistory(boolean stateTransitionHistory) {
        this.stateTransitionHistory = stateTransitionHistory;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AgentCapabilities that = (AgentCapabilities)o;
        return this.streaming == that.streaming && this.pushNotifications == that.pushNotifications && this.stateTransitionHistory == that.stateTransitionHistory;
    }

    public int hashCode() {
        return Objects.hash(this.streaming, this.pushNotifications, this.stateTransitionHistory);
    }

    public String toString() {
        return "AgentCapabilities{streaming=" + this.streaming + ", pushNotifications=" + this.pushNotifications + ", stateTransitionHistory=" + this.stateTransitionHistory + "}";
    }

    public static class Builder {
        private boolean streaming = false;
        private boolean pushNotifications = false;
        private boolean stateTransitionHistory = false;

        private Builder() {
        }

        public Builder streaming(boolean streaming) {
            this.streaming = streaming;
            return this;
        }

        public Builder pushNotifications(boolean pushNotifications) {
            this.pushNotifications = pushNotifications;
            return this;
        }

        public Builder stateTransitionHistory(boolean stateTransitionHistory) {
            this.stateTransitionHistory = stateTransitionHistory;
            return this;
        }

        public AgentCapabilities build() {
            return new AgentCapabilities(this.streaming, this.pushNotifications, this.stateTransitionHistory);
        }
    }
}

