/*
 * Decompiled with CFR 0.152.
 */
package io.github.a2ap.core.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class AgentProvider {
    @NotNull
    private String organization;
    private String url;

    public AgentProvider() {
    }

    public AgentProvider(String organization, String url) {
        this.organization = organization;
        this.url = url;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOrganization() {
        return this.organization;
    }

    public void setOrganization(String organization) {
        this.organization = organization;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AgentProvider that = (AgentProvider)o;
        return Objects.equals(this.organization, that.organization) && Objects.equals(this.url, that.url);
    }

    public int hashCode() {
        return Objects.hash(this.organization, this.url);
    }

    public String toString() {
        return "AgentProvider{organization='" + this.organization + "', url='" + this.url + "'}";
    }

    public static class Builder {
        private String organization;
        private String url;

        private Builder() {
        }

        public Builder organization(String organization) {
            this.organization = organization;
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public AgentProvider build() {
            return new AgentProvider(this.organization, this.url);
        }
    }
}

