/*
 * Decompiled with CFR 0.152.
 */
package io.github.a2ap.core.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.a2ap.core.model.FileContent;
import io.github.a2ap.core.model.Part;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class FilePart
extends Part {
    @JsonProperty(value="kind")
    private final String kind = "file";
    @JsonProperty(value="file")
    private FileContent file;

    public FilePart() {
    }

    public FilePart(FileContent file) {
        this.file = file;
    }

    public FilePart(FileContent file, Map<String, Object> metadata) {
        super("file", metadata);
        this.file = file;
    }

    @Override
    public String getKind() {
        return "file";
    }

    public FileContent getFile() {
        return this.file;
    }

    public void setFile(FileContent file) {
        this.file = file;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FilePart filePart = (FilePart)o;
        return Objects.equals(this.file, filePart.file);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), "file", this.file);
    }

    @Override
    public String toString() {
        return "FilePart{kind='file', file=" + this.file + ", metadata=" + this.getMetadata() + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private FileContent file;
        private Map<String, Object> metadata;

        private Builder() {
        }

        public Builder file(FileContent file) {
            this.file = file;
            return this;
        }

        public Builder metadata(Map<String, Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        public FilePart build() {
            return new FilePart(this.file, this.metadata);
        }
    }
}

