/*
 * Decompiled with CFR 0.152.
 */
package io.github.a2ap.core.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.a2ap.core.model.Message;
import io.github.a2ap.core.model.MessageSendConfiguration;
import java.util.Map;
import java.util.Objects;

public class MessageSendParams {
    @JsonProperty(value="message")
    private Message message;
    @JsonProperty(value="configuration")
    private MessageSendConfiguration configuration;
    @JsonProperty(value="metadata")
    private Map<String, Object> metadata;

    public MessageSendParams() {
    }

    public MessageSendParams(Message message, MessageSendConfiguration configuration, Map<String, Object> metadata) {
        this.message = message;
        this.configuration = configuration;
        this.metadata = metadata;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Message getMessage() {
        return this.message;
    }

    public void setMessage(Message message) {
        this.message = message;
    }

    public MessageSendConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(MessageSendConfiguration configuration) {
        this.configuration = configuration;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageSendParams that = (MessageSendParams)o;
        return Objects.equals(this.message, that.message) && Objects.equals(this.configuration, that.configuration) && Objects.equals(this.metadata, that.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.message, this.configuration, this.metadata);
    }

    public String toString() {
        return "MessageSendParams{message=" + this.message + ", configuration=" + this.configuration + ", metadata=" + this.metadata + "}";
    }

    public static class Builder {
        private Message message;
        private MessageSendConfiguration configuration;
        private Map<String, Object> metadata;

        private Builder() {
        }

        public Builder message(Message message) {
            this.message = message;
            return this;
        }

        public Builder configuration(MessageSendConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public Builder metadata(Map<String, Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        public MessageSendParams build() {
            return new MessageSendParams(this.message, this.configuration, this.metadata);
        }
    }
}

