/*
 * Decompiled with CFR 0.152.
 */
package io.github.a2ap.core.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SecurityScheme {
    private String type;
    private String scheme;
    private String name;
    private String in;
    private String description;
    private String bearerFormat;

    public SecurityScheme() {
    }

    public SecurityScheme(String type, String scheme, String name, String in, String description, String bearerFormat) {
        this.type = type;
        this.scheme = scheme;
        this.name = name;
        this.in = in;
        this.description = description;
        this.bearerFormat = bearerFormat;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getIn() {
        return this.in;
    }

    public void setIn(String in) {
        this.in = in;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getBearerFormat() {
        return this.bearerFormat;
    }

    public void setBearerFormat(String bearerFormat) {
        this.bearerFormat = bearerFormat;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecurityScheme that = (SecurityScheme)o;
        return Objects.equals(this.type, that.type) && Objects.equals(this.scheme, that.scheme) && Objects.equals(this.name, that.name) && Objects.equals(this.in, that.in) && Objects.equals(this.description, that.description) && Objects.equals(this.bearerFormat, that.bearerFormat);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.scheme, this.name, this.in, this.description, this.bearerFormat);
    }

    public String toString() {
        return "SecurityScheme{type='" + this.type + "', scheme='" + this.scheme + "', name='" + this.name + "', in='" + this.in + "', description='" + this.description + "', bearerFormat='" + this.bearerFormat + "'}";
    }

    public static class Builder {
        private String type;
        private String scheme;
        private String name;
        private String in;
        private String description;
        private String bearerFormat;

        private Builder() {
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder scheme(String scheme) {
            this.scheme = scheme;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder in(String in) {
            this.in = in;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder bearerFormat(String bearerFormat) {
            this.bearerFormat = bearerFormat;
            return this;
        }

        public SecurityScheme build() {
            return new SecurityScheme(this.type, this.scheme, this.name, this.in, this.description, this.bearerFormat);
        }
    }
}

