/*
 * Decompiled with CFR 0.152.
 */
package io.github.a2ap.core.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.a2ap.core.model.Artifact;
import io.github.a2ap.core.model.SendStreamingMessageResponse;
import java.util.Map;
import java.util.Objects;

public class TaskArtifactUpdateEvent
implements SendStreamingMessageResponse {
    @JsonProperty(value="taskId")
    private String taskId;
    @JsonProperty(value="contextId")
    private String contextId;
    @JsonProperty(value="kind")
    private String kind = "artifact-update";
    @JsonProperty(value="artifact")
    private Artifact artifact;
    @JsonProperty(value="final")
    private Boolean isFinal;
    @JsonProperty(value="append")
    private Boolean append;
    @JsonProperty(value="lastChunk")
    private Boolean lastChunk;
    @JsonProperty(value="metadata")
    private Map<String, Object> metadata;

    public TaskArtifactUpdateEvent() {
    }

    public TaskArtifactUpdateEvent(String taskId, String contextId, String kind, Artifact artifact, Boolean isFinal, Boolean append, Boolean lastChunk, Map<String, Object> metadata) {
        this.taskId = taskId;
        this.contextId = contextId;
        this.kind = kind != null ? kind : "artifact-update";
        this.artifact = artifact;
        this.isFinal = isFinal;
        this.append = append;
        this.lastChunk = lastChunk;
        this.metadata = metadata;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public String getContextId() {
        return this.contextId;
    }

    public void setContextId(String contextId) {
        this.contextId = contextId;
    }

    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind != null ? kind : "artifact-update";
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public void setArtifact(Artifact artifact) {
        this.artifact = artifact;
    }

    public Boolean getIsFinal() {
        return this.isFinal;
    }

    public void setIsFinal(Boolean isFinal) {
        this.isFinal = isFinal;
    }

    public Boolean getAppend() {
        return this.append;
    }

    public void setAppend(Boolean append) {
        this.append = append;
    }

    public Boolean getLastChunk() {
        return this.lastChunk;
    }

    public void setLastChunk(Boolean lastChunk) {
        this.lastChunk = lastChunk;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskArtifactUpdateEvent that = (TaskArtifactUpdateEvent)o;
        return Objects.equals(this.taskId, that.taskId) && Objects.equals(this.contextId, that.contextId) && Objects.equals(this.kind, that.kind) && Objects.equals(this.artifact, that.artifact) && Objects.equals(this.isFinal, that.isFinal) && Objects.equals(this.append, that.append) && Objects.equals(this.lastChunk, that.lastChunk) && Objects.equals(this.metadata, that.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.taskId, this.contextId, this.kind, this.artifact, this.isFinal, this.append, this.lastChunk, this.metadata);
    }

    public String toString() {
        return "TaskArtifactUpdateEvent{taskId='" + this.taskId + "', contextId='" + this.contextId + "', kind='" + this.kind + "', artifact=" + this.artifact + ", isFinal=" + this.isFinal + ", append=" + this.append + ", lastChunk=" + this.lastChunk + ", metadata=" + this.metadata + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String taskId;
        private String contextId;
        private String kind = "artifact-update";
        private Artifact artifact;
        private Boolean isFinal;
        private Boolean append;
        private Boolean lastChunk;
        private Map<String, Object> metadata;

        private Builder() {
        }

        public Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public Builder contextId(String contextId) {
            this.contextId = contextId;
            return this;
        }

        public Builder kind(String kind) {
            this.kind = kind != null ? kind : "artifact-update";
            return this;
        }

        public Builder artifact(Artifact artifact) {
            this.artifact = artifact;
            return this;
        }

        public Builder isFinal(Boolean isFinal) {
            this.isFinal = isFinal;
            return this;
        }

        public Builder append(Boolean append) {
            this.append = append;
            return this;
        }

        public Builder lastChunk(Boolean lastChunk) {
            this.lastChunk = lastChunk;
            return this;
        }

        public Builder metadata(Map<String, Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        public TaskArtifactUpdateEvent build() {
            return new TaskArtifactUpdateEvent(this.taskId, this.contextId, this.kind, this.artifact, this.isFinal, this.append, this.lastChunk, this.metadata);
        }
    }
}

