/*
 * Decompiled with CFR 0.152.
 */
package io.github.a2ap.core.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.a2ap.core.model.SendStreamingMessageResponse;
import io.github.a2ap.core.model.TaskStatus;
import java.util.Map;
import java.util.Objects;

public class TaskStatusUpdateEvent
implements SendStreamingMessageResponse {
    @JsonProperty(value="taskId")
    private String taskId;
    @JsonProperty(value="contextId")
    private String contextId;
    @JsonProperty(value="kind")
    private String kind = "status-update";
    @JsonProperty(value="status")
    private TaskStatus status;
    @JsonProperty(value="final")
    private Boolean isFinal;
    @JsonProperty(value="metadata")
    private Map<String, Object> metadata;

    public TaskStatusUpdateEvent() {
    }

    public TaskStatusUpdateEvent(String taskId, String contextId, String kind, TaskStatus status, Boolean isFinal, Map<String, Object> metadata) {
        this.taskId = taskId;
        this.contextId = contextId;
        this.kind = kind != null ? kind : "status-update";
        this.status = status;
        this.isFinal = isFinal;
        this.metadata = metadata;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public String getContextId() {
        return this.contextId;
    }

    public void setContextId(String contextId) {
        this.contextId = contextId;
    }

    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind != null ? kind : "status-update";
    }

    public TaskStatus getStatus() {
        return this.status;
    }

    public void setStatus(TaskStatus status) {
        this.status = status;
    }

    public Boolean getIsFinal() {
        return this.isFinal;
    }

    public void setIsFinal(Boolean isFinal) {
        this.isFinal = isFinal;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskStatusUpdateEvent that = (TaskStatusUpdateEvent)o;
        return Objects.equals(this.taskId, that.taskId) && Objects.equals(this.contextId, that.contextId) && Objects.equals(this.kind, that.kind) && Objects.equals(this.status, that.status) && Objects.equals(this.isFinal, that.isFinal) && Objects.equals(this.metadata, that.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.taskId, this.contextId, this.kind, this.status, this.isFinal, this.metadata);
    }

    public String toString() {
        return "TaskStatusUpdateEvent{taskId='" + this.taskId + "', contextId='" + this.contextId + "', kind='" + this.kind + "', status=" + this.status + ", isFinal=" + this.isFinal + ", metadata=" + this.metadata + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String taskId;
        private String contextId;
        private String kind = "status-update";
        private TaskStatus status;
        private Boolean isFinal;
        private Map<String, Object> metadata;

        private Builder() {
        }

        public Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public Builder contextId(String contextId) {
            this.contextId = contextId;
            return this;
        }

        public Builder kind(String kind) {
            this.kind = kind != null ? kind : "status-update";
            return this;
        }

        public Builder status(TaskStatus status) {
            this.status = status;
            return this;
        }

        public Builder isFinal(Boolean isFinal) {
            this.isFinal = isFinal;
            return this;
        }

        public Builder metadata(Map<String, Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        public TaskStatusUpdateEvent build() {
            return new TaskStatusUpdateEvent(this.taskId, this.contextId, this.kind, this.status, this.isFinal, this.metadata);
        }
    }
}

