/*
 * Decompiled with CFR 0.152.
 */
package org.ddr.poi.html.util;

import com.steadystate.css.dom.CSSStyleDeclarationImpl;
import com.steadystate.css.dom.CSSValueImpl;
import com.steadystate.css.dom.Property;
import com.steadystate.css.parser.CSSOMParser;
import com.steadystate.css.parser.SACParserCSS3;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.ddr.poi.html.HtmlConstants;
import org.ddr.poi.html.util.BoxProperty;
import org.ddr.poi.html.util.CSSLength;
import org.ddr.poi.html.util.Colors;
import org.ddr.poi.html.util.EmptyCSSStyle;
import org.ddr.poi.html.util.NamedBorderWidth;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.Parser;
import org.w3c.dom.css.CSSValue;

public class CSSStyleUtils {
    private static final Logger log = LoggerFactory.getLogger(CSSStyleUtils.class);
    public static final CSSStyleDeclarationImpl EMPTY_STYLE = new EmptyCSSStyle();

    public static boolean isEmpty(CSSStyleDeclarationImpl style) {
        return style == null || EMPTY_STYLE.equals((Object)style) || style.getProperties().isEmpty();
    }

    public static CSSOMParser newParser() {
        return new CSSOMParser((Parser)new SACParserCSS3());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CSSStyleDeclarationImpl parse(String inlineStyle) {
        try (StringReader sr = new StringReader(inlineStyle);){
            CSSStyleDeclarationImpl cSSStyleDeclarationImpl = (CSSStyleDeclarationImpl)CSSStyleUtils.newParser().parseStyleDeclaration(new InputSource((Reader)sr));
            return cSSStyleDeclarationImpl;
        }
        catch (IOException e) {
            log.warn("Inline style parse error: {}", (Object)inlineStyle, (Object)e);
            return EMPTY_STYLE;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CSSStyleDeclarationImpl parseNew(String inlineStyle) {
        try (StringReader sr = new StringReader(inlineStyle);){
            CSSStyleDeclarationImpl cSSStyleDeclarationImpl = (CSSStyleDeclarationImpl)CSSStyleUtils.newParser().parseStyleDeclaration(new InputSource((Reader)sr));
            return cSSStyleDeclarationImpl;
        }
        catch (IOException e) {
            log.warn("Inline style parse error: {}", (Object)inlineStyle, (Object)e);
            return new CSSStyleDeclarationImpl();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CSSValue parseValue(String value) {
        try (StringReader sr = new StringReader(value);){
            CSSValue cSSValue = CSSStyleUtils.newParser().parsePropertyValue(new InputSource((Reader)sr));
            return cSSValue;
        }
        catch (IOException e) {
            log.warn("CSS value parse error: {}", (Object)value, (Object)e);
            return new CSSValueImpl();
        }
    }

    public static Property newProperty(String key, String value) {
        return new Property(key, CSSStyleUtils.parseValue(value), false);
    }

    public static void split(CSSStyleDeclarationImpl style) {
        block32: for (int i = style.getProperties().size() - 1; i >= 0; --i) {
            Property p = (Property)style.getProperties().get(i);
            if (p == null || p.getValue() == null) continue;
            String name = p.getName().toLowerCase();
            CSSValueImpl valueList = (CSSValueImpl)p.getValue();
            int length = valueList.getLength();
            switch (name) {
                case "background": {
                    CSSStyleUtils.splitBackground(valueList, length, style, i);
                    continue block32;
                }
                case "border": {
                    CSSStyleUtils.splitBorder(valueList, length, style, i);
                    continue block32;
                }
                case "border-top": {
                    CSSStyleUtils.splitBorder(valueList, length, style, i, "border-top-style", "border-top-width", "border-top-color");
                    continue block32;
                }
                case "border-right": {
                    CSSStyleUtils.splitBorder(valueList, length, style, i, "border-right-style", "border-right-width", "border-right-color");
                    continue block32;
                }
                case "border-bottom": {
                    CSSStyleUtils.splitBorder(valueList, length, style, i, "border-bottom-style", "border-bottom-width", "border-bottom-color");
                    continue block32;
                }
                case "border-left": {
                    CSSStyleUtils.splitBorder(valueList, length, style, i, "border-left-style", "border-left-width", "border-left-color");
                    continue block32;
                }
                case "border-style": {
                    CSSStyleUtils.splitBox(valueList, length, style, i, BoxProperty.BORDER_STYLE);
                    continue block32;
                }
                case "border-width": {
                    CSSStyleUtils.splitBox(valueList, length, style, i, BoxProperty.BORDER_WIDTH);
                    continue block32;
                }
                case "border-color": {
                    CSSStyleUtils.splitBox(valueList, length, style, i, BoxProperty.BORDER_COLOR);
                    continue block32;
                }
                case "font": {
                    CSSStyleUtils.splitFont(valueList, length, style, i);
                    continue block32;
                }
                case "margin": {
                    CSSStyleUtils.splitBox(valueList, length, style, i, BoxProperty.MARGIN);
                    continue block32;
                }
                case "padding": {
                    CSSStyleUtils.splitBox(valueList, length, style, i, BoxProperty.PADDING);
                    continue block32;
                }
                case "list-style": {
                    CSSStyleUtils.splitListStyle(valueList, length, style, i);
                    continue block32;
                }
                case "text-decoration": {
                    CSSStyleUtils.splitTextDecoration(valueList, length, style, i);
                }
            }
        }
    }

    private static void splitBackground(CSSValueImpl valueList, int length, CSSStyleDeclarationImpl style, int i) {
        block2: {
            block1: {
                if (length != 0) break block1;
                String cssText = valueList.getCssText().toLowerCase();
                String color = Colors.fromStyle(cssText, null);
                if (color == null) break block2;
                style.getProperties().add(i, new Property("background-color", (CSSValue)valueList, false));
                break block2;
            }
            for (int j = 0; j < length; ++j) {
                CSSValue item = valueList.item(j);
                String cssText = item.getCssText().toLowerCase();
                String color = Colors.fromStyle(cssText, null);
                if (color == null) continue;
                style.getProperties().add(i, new Property("background-color", item, false));
                break;
            }
        }
    }

    private static void splitBorder(CSSValueImpl valueList, int length, CSSStyleDeclarationImpl style, int i) {
        if (length == 0) {
            String cssText = valueList.getCssText();
            if (StringUtils.isNotBlank((CharSequence)cssText)) {
                CSSStyleUtils.handleBorderValue(style, i, (CSSValue)valueList, cssText);
            }
        } else {
            for (int j = 0; j < length; ++j) {
                CSSValue item = valueList.item(j);
                String value = item.getCssText();
                CSSStyleUtils.handleBorderValue(style, i, item, value);
            }
        }
    }

    private static void splitBorder(CSSValueImpl valueList, int length, CSSStyleDeclarationImpl style, int i, String styleProperty, String widthProperty, String colorProperty) {
        if (length == 0) {
            String cssText = valueList.getCssText();
            if (StringUtils.isNotBlank((CharSequence)cssText)) {
                CSSStyleUtils.handleBorderValue(style, i, (CSSValue)valueList, cssText, styleProperty, widthProperty, colorProperty);
            }
        } else {
            for (int j = 0; j < length; ++j) {
                CSSValue item = valueList.item(j);
                String value = item.getCssText();
                CSSStyleUtils.handleBorderValue(style, i, item, value, styleProperty, widthProperty, colorProperty);
            }
        }
    }

    private static void handleBorderValue(CSSStyleDeclarationImpl style, int i, CSSValue item, String value) {
        if (HtmlConstants.BORDER_STYLES.contains(value = value.toLowerCase())) {
            BoxProperty.BORDER_STYLE.setValues(style, i, item);
        } else if (NamedBorderWidth.contains(value)) {
            BoxProperty.BORDER_WIDTH.setValues(style, i, item);
        } else if (Character.isDigit(value.charAt(0))) {
            CSSLength width = CSSLength.of(value);
            if (width.isValid()) {
                BoxProperty.BORDER_WIDTH.setValues(style, i, item);
            }
        } else {
            BoxProperty.BORDER_COLOR.setValues(style, i, item);
        }
    }

    private static void handleBorderValue(CSSStyleDeclarationImpl style, int i, CSSValue item, String value, String styleProperty, String widthProperty, String colorProperty) {
        if (HtmlConstants.BORDER_STYLES.contains(value = value.toLowerCase())) {
            style.getProperties().add(i, new Property(styleProperty, item, false));
        } else if (NamedBorderWidth.contains(value)) {
            style.getProperties().add(i, new Property(widthProperty, item, false));
        } else if (Character.isDigit(value.charAt(0))) {
            CSSLength width = CSSLength.of(value);
            if (width.isValid()) {
                style.getProperties().add(i, new Property(widthProperty, item, false));
            }
        } else {
            style.getProperties().add(i, new Property(colorProperty, item, false));
        }
    }

    private static void splitFont(CSSValueImpl valueList, int length, CSSStyleDeclarationImpl style, int i) {
        if (length == 0) {
            return;
        }
        boolean styleHandled = false;
        boolean sizeHandled = false;
        block0: for (int j = 0; j < length; ++j) {
            CSSValue item = valueList.item(j);
            String value = item.getCssText();
            String lowerCase = value.toLowerCase();
            if (!styleHandled && HtmlConstants.FONT_STYLES.contains(lowerCase)) {
                style.getProperties().add(i, new Property("font-style", item, false));
                styleHandled = true;
                continue;
            }
            if (HtmlConstants.FONT_VARIANTS.contains(lowerCase)) {
                style.getProperties().add(i, new Property("font-variant-caps", item, false));
                continue;
            }
            if (HtmlConstants.FONT_WEIGHTS.contains(lowerCase) || NumberUtils.isParsable((String)value)) {
                style.getProperties().add(i, new Property("font-weight", item, false));
                continue;
            }
            if ("/".equals(value)) {
                CSSValue fontSize = valueList.item(j - 1);
                style.getProperties().add(i, new Property("font-size", fontSize, false));
                sizeHandled = true;
                if (++j >= length) continue;
                CSSValue lineHeight = valueList.item(j);
                style.getProperties().add(i, new Property("line-height", lineHeight, false));
                continue;
            }
            if (",".equals(value)) {
                CSSValue firstFont = valueList.item(j - 1);
                if (!sizeHandled) {
                    CSSValue fontSize = valueList.item(j - 2);
                    style.getProperties().add(i, new Property("font-size", fontSize, false));
                }
                if (HtmlConstants.isMajorFont(firstFont.getCssText())) {
                    style.getProperties().add(i, new Property("font-family", firstFont, false));
                    break;
                }
                ++j;
                while (j < length) {
                    CSSValue fontFamily = valueList.item(j);
                    if (HtmlConstants.isMajorFont(fontFamily.getCssText())) {
                        style.getProperties().add(i, new Property("font-family", fontFamily, false));
                        break block0;
                    }
                    ++j;
                }
                break;
            }
            if (j != length - 1) continue;
            style.getProperties().add(i, new Property("font-family", item, false));
        }
    }

    private static void splitBox(CSSValueImpl valueList, int length, CSSStyleDeclarationImpl style, int i, BoxProperty boxProperty) {
        switch (length) {
            case 0: 
            case 1: {
                if (!StringUtils.isNotBlank((CharSequence)valueList.getCssText())) break;
                boxProperty.setValues(style, i, (CSSValue)valueList);
                break;
            }
            case 2: {
                boxProperty.setValues(style, i, valueList.item(0), valueList.item(1));
                break;
            }
            case 3: {
                boxProperty.setValues(style, i, valueList.item(0), valueList.item(1), valueList.item(2));
                break;
            }
            case 4: {
                boxProperty.setValues(style, i, valueList.item(0), valueList.item(1), valueList.item(2), valueList.item(3));
            }
        }
    }

    private static void splitListStyle(CSSValueImpl valueList, int length, CSSStyleDeclarationImpl style, int i) {
        switch (length) {
            case 0: 
            case 1: {
                if (!StringUtils.isNotBlank((CharSequence)valueList.getCssText())) break;
                style.getProperties().add(i, new Property("list-style-type", (CSSValue)valueList, false));
                break;
            }
            default: {
                style.getProperties().add(i, new Property("list-style-type", valueList.item(0), false));
            }
        }
    }

    private static void splitTextDecoration(CSSValueImpl valueList, int length, CSSStyleDeclarationImpl style, int i) {
        if (length == 0) {
            style.getProperties().add(i, new Property("text-decoration-line", (CSSValue)valueList, false));
            return;
        }
        StringBuilder lines = new StringBuilder(22);
        for (int j = 0; j < length; ++j) {
            CSSValue item = valueList.item(j);
            String value = item.getCssText();
            String lowerCase = value.toLowerCase();
            if ("none".equals(lowerCase)) {
                style.getProperties().add(i, new Property("text-decoration-line", item, false));
                break;
            }
            if (HtmlConstants.TEXT_DECORATION_LINES.contains(lowerCase)) {
                if (lines.length() > 0) {
                    lines.append(' ');
                }
                lines.append(lowerCase);
                continue;
            }
            if (HtmlConstants.TEXT_DECORATION_STYLES.contains(lowerCase)) {
                style.getProperties().add(i, new Property("text-decoration-style", item, false));
                continue;
            }
            if (!Colors.maybe(lowerCase)) continue;
            style.getProperties().add(i, new Property("text-decoration-color", item, false));
        }
        if (lines.length() > 0) {
            style.getProperties().add(i, CSSStyleUtils.newProperty("text-decoration-line", lines.toString()));
        }
    }
}

