/*
 * Decompiled with CFR 0.152.
 */
package org.ddr.poi.html.util;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum WhiteSpaceRule {
    NORMAL("normal", false, false, false),
    NO_WRAP("nowrap", false, false, false),
    PRE("pre", true, true, true),
    PRE_WRAP("pre-wrap", true, true, true),
    PRE_LINE("pre-line", true, false, false),
    BREAK_SPACES("break-spaces", true, true, true);

    private final String value;
    private final boolean keepLineBreak;
    private final boolean keepSpaceAndTab;
    private final boolean keepTrailingSpace;
    private static Map<String, WhiteSpaceRule> rules;

    private WhiteSpaceRule(String value, boolean keepLineBreak, boolean keepSpaceAndTab, boolean keepTrailingSpace) {
        this.value = value;
        this.keepLineBreak = keepLineBreak;
        this.keepSpaceAndTab = keepSpaceAndTab;
        this.keepTrailingSpace = keepTrailingSpace;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isKeepLineBreak() {
        return this.keepLineBreak;
    }

    public boolean isKeepSpaceAndTab() {
        return this.keepSpaceAndTab;
    }

    public boolean isKeepTrailingSpace() {
        return this.keepTrailingSpace;
    }

    public static WhiteSpaceRule of(String value) {
        return rules.getOrDefault(value, NORMAL);
    }

    static {
        rules = Arrays.stream(WhiteSpaceRule.values()).collect(Collectors.toMap(WhiteSpaceRule::getValue, Function.identity()));
    }
}

