/*
 * Decompiled with CFR 0.152.
 */
package org.ddr.poi.latex;

import com.deepoove.poi.policy.AbstractRenderPolicy;
import com.deepoove.poi.render.RenderContext;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.ddr.poi.math.MathMLUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import uk.ac.ed.ph.snuggletex.SerializationSpecifier;
import uk.ac.ed.ph.snuggletex.SnuggleEngine;
import uk.ac.ed.ph.snuggletex.SnuggleInput;
import uk.ac.ed.ph.snuggletex.SnuggleSession;
import uk.ac.ed.ph.snuggletex.definitions.CorePackageDefinitions;
import uk.ac.ed.ph.snuggletex.internal.util.XMLUtilities;
import uk.ac.ed.ph.snuggletex.utilities.DefaultTransformerFactoryChooser;
import uk.ac.ed.ph.snuggletex.utilities.TransformerFactoryChooser;

public class LaTeXRenderPolicy
extends AbstractRenderPolicy<String> {
    private SnuggleSession session;

    protected boolean validate(String data) {
        if (StringUtils.isBlank((CharSequence)data)) {
            return false;
        }
        this.session = Initializer.SNUGGLE_ENGINE.createSession();
        SnuggleInput input = new SnuggleInput(data);
        boolean valid = false;
        try {
            valid = this.session.parseInput(input);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return valid;
    }

    public void doRender(RenderContext<String> context) throws Exception {
        XWPFParagraph paragraph = (XWPFParagraph)context.getRun().getParent();
        NodeList nodeList = this.session.buildDOMSubtree();
        int length = nodeList.getLength();
        for (int i = 0; i < length; ++i) {
            Node node = nodeList.item(i);
            if (node instanceof Text) {
                paragraph.getCTP().addNewR().addNewT().setStringValue(node.getTextContent());
                continue;
            }
            if (!"math".equals(node.getLocalName())) continue;
            String math = XMLUtilities.serializeNode((Node)node, (SerializationSpecifier)Initializer.SNUGGLE_ENGINE.getDefaultXMLStringOutputOptions());
            MathMLUtils.renderTo(paragraph, context.getRun(), math);
        }
    }

    protected void afterRender(RenderContext<String> context) {
        this.clearPlaceholder(context, false);
    }

    private static class Initializer {
        static final SnuggleEngine SNUGGLE_ENGINE = new SnuggleEngine((TransformerFactoryChooser)DefaultTransformerFactoryChooser.getInstance(), null);

        private Initializer() {
        }

        static {
            CorePackageDefinitions.getPackage().loadMathCharacterAliases("math-character-aliases.txt");
        }
    }
}

