/*
 * Decompiled with CFR 0.152.
 */
package org.ddr.poi.html.util;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.ddr.poi.html.util.CSSLength;
import org.ddr.poi.html.util.CSSLengthUnit;

public enum NamedBorderWidth {
    THIN("thin", 1),
    MEDIUM("medium", 3),
    THICK("thick", 5);

    private final String name;
    private final CSSLength width;
    private static final Map<String, NamedBorderWidth> NAMED_MAP;

    private NamedBorderWidth(String name, int px) {
        this.name = name;
        this.width = new CSSLength(px, CSSLengthUnit.PX);
    }

    public String getName() {
        return this.name;
    }

    public CSSLength getWidth() {
        return this.width;
    }

    public static NamedBorderWidth of(String name) {
        return NAMED_MAP.get(name);
    }

    public static boolean contains(String name) {
        return NAMED_MAP.containsKey(name);
    }

    static {
        NAMED_MAP = Arrays.stream(NamedBorderWidth.values()).collect(Collectors.toMap(NamedBorderWidth::getName, Function.identity()));
    }
}

