/*
 * Decompiled with CFR 0.152.
 */
package cn.jiguang.sdk.api;

import cn.jiguang.sdk.bean.device.AliasDeleteParam;
import cn.jiguang.sdk.bean.device.AliasGetResult;
import cn.jiguang.sdk.bean.device.DeviceGetResult;
import cn.jiguang.sdk.bean.device.DeviceSetParam;
import cn.jiguang.sdk.bean.device.DeviceStatusGetResult;
import cn.jiguang.sdk.bean.device.TagGetResult;
import cn.jiguang.sdk.bean.device.TagSetParam;
import cn.jiguang.sdk.bean.device.TagsGetResult;
import cn.jiguang.sdk.client.DeviceClient;
import cn.jiguang.sdk.codec.ApiDecoder;
import cn.jiguang.sdk.codec.ApiEncoder;
import cn.jiguang.sdk.codec.ApiErrorDecoder;
import cn.jiguang.sdk.enums.platform.Platform;
import feign.Client;
import feign.Feign;
import feign.Logger;
import feign.RequestInterceptor;
import feign.auth.BasicAuthRequestInterceptor;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.codec.ErrorDecoder;
import feign.slf4j.Slf4jLogger;
import java.net.Proxy;
import lombok.NonNull;
import okhttp3.OkHttpClient;

public class DeviceApi {
    private final DeviceClient deviceClient;

    protected DeviceApi(@NonNull DeviceClient deviceClient) {
        if (deviceClient == null) {
            throw new NullPointerException("deviceClient is marked non-null but is null");
        }
        this.deviceClient = deviceClient;
    }

    public DeviceGetResult getDevice(@NonNull String registrationId) {
        if (registrationId == null) {
            throw new NullPointerException("registrationId is marked non-null but is null");
        }
        return this.deviceClient.getDevice(registrationId);
    }

    public void setDevice(@NonNull String registrationId, @NonNull DeviceSetParam param) {
        if (registrationId == null) {
            throw new NullPointerException("registrationId is marked non-null but is null");
        }
        if (param == null) {
            throw new NullPointerException("param is marked non-null but is null");
        }
        this.deviceClient.setDevice(registrationId, param);
    }

    public AliasGetResult getAlias(@NonNull String alias) {
        if (alias == null) {
            throw new NullPointerException("alias is marked non-null but is null");
        }
        return this.getAlias(alias, null);
    }

    public AliasGetResult getAlias(@NonNull String alias, Platform platform) {
        if (alias == null) {
            throw new NullPointerException("alias is marked non-null but is null");
        }
        return this.deviceClient.getAlias(alias, platform);
    }

    public void deleteAlias(@NonNull String alias) {
        if (alias == null) {
            throw new NullPointerException("alias is marked non-null but is null");
        }
        this.deleteAlias(alias, null);
    }

    public void deleteAlias(@NonNull String alias, Platform platform) {
        if (alias == null) {
            throw new NullPointerException("alias is marked non-null but is null");
        }
        this.deviceClient.deleteAlias(alias, platform);
    }

    public void deleteAliases(@NonNull String alias, @NonNull AliasDeleteParam param) {
        if (alias == null) {
            throw new NullPointerException("alias is marked non-null but is null");
        }
        if (param == null) {
            throw new NullPointerException("param is marked non-null but is null");
        }
        this.deviceClient.deleteAliases(alias, param);
    }

    public TagsGetResult getTags() {
        return this.deviceClient.getTags();
    }

    public TagGetResult getTag(@NonNull String tag, @NonNull String registrationId) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        if (registrationId == null) {
            throw new NullPointerException("registrationId is marked non-null but is null");
        }
        return this.deviceClient.getTag(tag, registrationId);
    }

    public void setTag(@NonNull String tag, @NonNull TagSetParam param) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        if (param == null) {
            throw new NullPointerException("param is marked non-null but is null");
        }
        this.deviceClient.setTag(tag, param);
    }

    public void deleteTag(@NonNull String tag) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        this.deleteTag(tag, null);
    }

    public void deleteTag(@NonNull String tag, Platform platform) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        this.deviceClient.deleteTag(tag, platform);
    }

    public DeviceStatusGetResult getDeviceStatus() {
        return this.deviceClient.getDeviceStatus();
    }

    public static class Builder {
        private String host = "https://device.jpush.cn";
        private Proxy proxy;
        private String appKey;
        private String masterSecret;
        private Logger.Level loggerLevel = Logger.Level.BASIC;

        public Builder setHost(@NonNull String host) {
            if (host == null) {
                throw new NullPointerException("host is marked non-null but is null");
            }
            this.host = host;
            return this;
        }

        public Builder setProxy(@NonNull Proxy proxy) {
            if (proxy == null) {
                throw new NullPointerException("proxy is marked non-null but is null");
            }
            this.proxy = proxy;
            return this;
        }

        public Builder setAppKey(@NonNull String appKey) {
            if (appKey == null) {
                throw new NullPointerException("appKey is marked non-null but is null");
            }
            this.appKey = appKey;
            return this;
        }

        public Builder setMasterSecret(@NonNull String masterSecret) {
            if (masterSecret == null) {
                throw new NullPointerException("masterSecret is marked non-null but is null");
            }
            this.masterSecret = masterSecret;
            return this;
        }

        public Builder setLoggerLevel(@NonNull Logger.Level loggerLevel) {
            if (loggerLevel == null) {
                throw new NullPointerException("loggerLevel is marked non-null but is null");
            }
            this.loggerLevel = loggerLevel;
            return this;
        }

        public DeviceApi build() {
            OkHttpClient.Builder delegateBuilder = new OkHttpClient().newBuilder();
            if (this.proxy != null) {
                delegateBuilder.proxy(this.proxy);
            }
            DeviceClient deviceClient = (DeviceClient)Feign.builder().client((Client)new feign.okhttp.OkHttpClient(delegateBuilder.build())).requestInterceptor((RequestInterceptor)new BasicAuthRequestInterceptor(this.appKey, this.masterSecret)).encoder((Encoder)new ApiEncoder()).decoder((Decoder)new ApiDecoder()).errorDecoder((ErrorDecoder)new ApiErrorDecoder()).logger((Logger)new Slf4jLogger()).logLevel(this.loggerLevel).target(DeviceClient.class, this.host);
            return new DeviceApi(deviceClient);
        }
    }
}

