/*
 * Decompiled with CFR 0.152.
 */
package cn.jiguang.sdk.api;

import cn.jiguang.sdk.bean.file.FileGetResult;
import cn.jiguang.sdk.bean.file.FileUploadParam;
import cn.jiguang.sdk.bean.file.FileUploadResult;
import cn.jiguang.sdk.bean.file.FilesGetResult;
import cn.jiguang.sdk.bean.image.ImageFileAddParam;
import cn.jiguang.sdk.bean.image.ImageFileAddResult;
import cn.jiguang.sdk.bean.image.ImageFileUpdateParam;
import cn.jiguang.sdk.bean.image.ImageFileUpdateResult;
import cn.jiguang.sdk.bean.image.ImageUrlAddParam;
import cn.jiguang.sdk.bean.image.ImageUrlAddResult;
import cn.jiguang.sdk.bean.image.ImageUrlUpdateParam;
import cn.jiguang.sdk.bean.image.ImageUrlUpdateResult;
import cn.jiguang.sdk.bean.push.PushSendParam;
import cn.jiguang.sdk.bean.push.PushSendResult;
import cn.jiguang.sdk.bean.push.SchedulePushSendParam;
import cn.jiguang.sdk.bean.push.SchedulePushSendResult;
import cn.jiguang.sdk.bean.push.other.CidGetResult;
import cn.jiguang.sdk.bean.push.other.QuotaGetResult;
import cn.jiguang.sdk.client.PushClient;
import cn.jiguang.sdk.codec.ApiDecoder;
import cn.jiguang.sdk.codec.ApiEncoder;
import cn.jiguang.sdk.codec.ApiErrorDecoder;
import feign.Client;
import feign.Feign;
import feign.Logger;
import feign.RequestInterceptor;
import feign.auth.BasicAuthRequestInterceptor;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.codec.ErrorDecoder;
import feign.slf4j.Slf4jLogger;
import java.net.Proxy;
import lombok.NonNull;
import okhttp3.OkHttpClient;

public class PushApi {
    private final PushClient pushClient;

    protected PushApi(@NonNull PushClient pushClient) {
        if (pushClient == null) {
            throw new NullPointerException("pushClient is marked non-null but is null");
        }
        this.pushClient = pushClient;
    }

    public PushSendResult send(@NonNull PushSendParam param) {
        if (param == null) {
            throw new NullPointerException("param is marked non-null but is null");
        }
        return this.pushClient.send(param);
    }

    public SchedulePushSendResult scheduleSend(@NonNull SchedulePushSendParam param) {
        if (param == null) {
            throw new NullPointerException("param is marked non-null but is null");
        }
        return this.pushClient.scheduleSend(param);
    }

    public CidGetResult getCidForPush(@NonNull int count) {
        return this.pushClient.getCidForPush(count);
    }

    public CidGetResult getCidForSchedulePush(@NonNull int count) {
        return this.pushClient.getCidForSchedulePush(count);
    }

    public PushSendResult validateSend(@NonNull PushSendParam param) {
        if (param == null) {
            throw new NullPointerException("param is marked non-null but is null");
        }
        return this.pushClient.validateSend(param);
    }

    public void withdrawMessage(@NonNull String messageId) {
        if (messageId == null) {
            throw new NullPointerException("messageId is marked non-null but is null");
        }
        this.pushClient.withdrawMessage(messageId);
    }

    public QuotaGetResult getQuota() {
        return this.pushClient.getQuota();
    }

    public PushSendResult sendByFile(@NonNull PushSendParam param) {
        if (param == null) {
            throw new NullPointerException("param is marked non-null but is null");
        }
        return this.pushClient.sendByFile(param);
    }

    public FileUploadResult uploadFileForAlias(@NonNull FileUploadParam param) {
        if (param == null) {
            throw new NullPointerException("param is marked non-null but is null");
        }
        return this.pushClient.uploadFileForAlias(param);
    }

    public FileUploadResult uploadFileForRegistrationId(@NonNull FileUploadParam param) {
        if (param == null) {
            throw new NullPointerException("param is marked non-null but is null");
        }
        return this.pushClient.uploadFileForRegistrationId(param);
    }

    public FilesGetResult getFiles() {
        return this.pushClient.getFiles();
    }

    public FileGetResult getFile(@NonNull String fileId) {
        if (fileId == null) {
            throw new NullPointerException("fileId is marked non-null but is null");
        }
        return this.pushClient.getFile(fileId);
    }

    public void deleteFile(@NonNull String fileId) {
        if (fileId == null) {
            throw new NullPointerException("fileId is marked non-null but is null");
        }
        this.pushClient.deleteFile(fileId);
    }

    public ImageUrlAddResult addImageUrl(@NonNull ImageUrlAddParam param) {
        if (param == null) {
            throw new NullPointerException("param is marked non-null but is null");
        }
        return this.pushClient.addImageUrl(param);
    }

    public ImageUrlUpdateResult updateImageUrl(@NonNull String mediaId, @NonNull ImageUrlUpdateParam param) {
        if (mediaId == null) {
            throw new NullPointerException("mediaId is marked non-null but is null");
        }
        if (param == null) {
            throw new NullPointerException("param is marked non-null but is null");
        }
        return this.pushClient.updateImageUrl(mediaId, param);
    }

    public ImageFileAddResult addImageFile(@NonNull ImageFileAddParam param) {
        if (param == null) {
            throw new NullPointerException("param is marked non-null but is null");
        }
        return this.pushClient.addImageFile(param);
    }

    public ImageFileUpdateResult updateImageFile(@NonNull String mediaId, @NonNull ImageFileUpdateParam param) {
        if (mediaId == null) {
            throw new NullPointerException("mediaId is marked non-null but is null");
        }
        if (param == null) {
            throw new NullPointerException("param is marked non-null but is null");
        }
        return this.pushClient.updateImageFile(mediaId, param);
    }

    public PushSendResult send(Object param) {
        return this.pushClient.send(param);
    }

    public SchedulePushSendResult scheduleSend(Object param) {
        return this.pushClient.scheduleSend(param);
    }

    public PushSendResult validateSend(Object param) {
        return this.pushClient.validateSend(param);
    }

    public PushSendResult sendByFile(Object param) {
        return this.pushClient.sendByFile(param);
    }

    public static class Builder {
        private String host = "https://api.jpush.cn";
        private Proxy proxy;
        private String appKey;
        private String masterSecret;
        private Logger.Level loggerLevel = Logger.Level.BASIC;

        public Builder setHost(@NonNull String host) {
            if (host == null) {
                throw new NullPointerException("host is marked non-null but is null");
            }
            this.host = host;
            return this;
        }

        public Builder setProxy(@NonNull Proxy proxy) {
            if (proxy == null) {
                throw new NullPointerException("proxy is marked non-null but is null");
            }
            this.proxy = proxy;
            return this;
        }

        public Builder setAppKey(@NonNull String appKey) {
            if (appKey == null) {
                throw new NullPointerException("appKey is marked non-null but is null");
            }
            this.appKey = appKey;
            return this;
        }

        public Builder setMasterSecret(@NonNull String masterSecret) {
            if (masterSecret == null) {
                throw new NullPointerException("masterSecret is marked non-null but is null");
            }
            this.masterSecret = masterSecret;
            return this;
        }

        public Builder setLoggerLevel(@NonNull Logger.Level loggerLevel) {
            if (loggerLevel == null) {
                throw new NullPointerException("loggerLevel is marked non-null but is null");
            }
            this.loggerLevel = loggerLevel;
            return this;
        }

        public PushApi build() {
            OkHttpClient.Builder delegateBuilder = new OkHttpClient().newBuilder();
            if (this.proxy != null) {
                delegateBuilder.proxy(this.proxy);
            }
            PushClient pushClient = (PushClient)Feign.builder().client((Client)new feign.okhttp.OkHttpClient(delegateBuilder.build())).requestInterceptor((RequestInterceptor)new BasicAuthRequestInterceptor(this.appKey, this.masterSecret)).encoder((Encoder)new ApiEncoder()).decoder((Decoder)new ApiDecoder()).errorDecoder((ErrorDecoder)new ApiErrorDecoder()).logger((Logger)new Slf4jLogger()).logLevel(this.loggerLevel).target(PushClient.class, this.host);
            return new PushApi(pushClient);
        }
    }
}

