/*
 * Decompiled with CFR 0.152.
 */
package cn.jiguang.sdk.codec;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import feign.FeignException;
import feign.Response;
import feign.codec.DecodeException;
import feign.codec.Decoder;
import feign.jackson.JacksonDecoder;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collection;

public class ApiDecoder
implements Decoder {
    private final JacksonDecoder jacksonDecoder;

    public ApiDecoder() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JavaTimeModule());
        this.jacksonDecoder = new JacksonDecoder(objectMapper);
    }

    public Object decode(Response response, Type type) throws IOException, DecodeException, FeignException {
        String contentType = ((Collection)response.headers().get("Content-Type")).stream().findFirst().orElse(null);
        if (contentType == null) {
            return null;
        }
        if (!contentType.startsWith("application/json")) {
            return null;
        }
        return this.jacksonDecoder.decode(response, type);
    }
}

