/*
 * Decompiled with CFR 0.152.
 */
package com.robot.util;

import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class LambdaExceptionUtil {
    public static <T, R, E extends Exception> Function<T, R> wrapFunction(FunctionWithExceptions<T, R, E> function) throws E {
        return t -> {
            try {
                return function.apply(t);
            }
            catch (Exception exception) {
                LambdaExceptionUtil.throwAsUnchecked(exception);
                return null;
            }
        };
    }

    public static <T, U, R, E extends Exception> BiFunction<T, U, R> wrapBiFunction(BiFunctionWithExceptions<T, U, R, E> biFunction) throws E {
        return (t, u) -> {
            try {
                return biFunction.apply(t, u);
            }
            catch (Exception exception) {
                LambdaExceptionUtil.throwAsUnchecked(exception);
                return null;
            }
        };
    }

    public static <T, E extends Exception> Consumer<T> wrapConsumer(ConsumerWithExceptions<T, E> consumer) throws E {
        return t -> {
            try {
                consumer.accept(t);
            }
            catch (Exception exception) {
                LambdaExceptionUtil.throwAsUnchecked(exception);
            }
        };
    }

    public static <T, U, E extends Exception> BiConsumer<T, U> wrapBiConsumer(BiConsumerWithExceptions<T, U, E> biConsumer) throws E {
        return (t, u) -> {
            try {
                biConsumer.accept(t, u);
            }
            catch (Exception exception) {
                LambdaExceptionUtil.throwAsUnchecked(exception);
            }
        };
    }

    public static <T, E extends Exception> Supplier<T> wrapSupplier(SupplierWithExceptions<T, E> function) throws E {
        return () -> {
            try {
                return function.get();
            }
            catch (Exception exception) {
                LambdaExceptionUtil.throwAsUnchecked(exception);
                return null;
            }
        };
    }

    public static <T, E extends Exception> Predicate<T> wrapPredicate(PredicateWithExceptions<T, E> predicate) throws E {
        return t -> {
            try {
                return predicate.test(t);
            }
            catch (Exception exception) {
                LambdaExceptionUtil.throwAsUnchecked(exception);
                return false;
            }
        };
    }

    public static <T, U, E extends Exception> BiPredicate<T, U> wrapBiPredicate(BiPredicateWithExceptions<T, U, E> predicate) throws E {
        return (t, u) -> {
            try {
                return predicate.test(t, u);
            }
            catch (Exception exception) {
                LambdaExceptionUtil.throwAsUnchecked(exception);
                return false;
            }
        };
    }

    public static <E extends Exception> void wrapRunnable(RunnableWithExceptions<E> runnable) throws E {
        try {
            runnable.run();
        }
        catch (Exception exception) {
            LambdaExceptionUtil.throwAsUnchecked(exception);
        }
    }

    public static <R, E extends Exception> R sure(SupplierWithExceptions<R, E> supplier) {
        try {
            return supplier.get();
        }
        catch (Exception exception) {
            LambdaExceptionUtil.throwAsUnchecked(exception);
            throw new UnreachableException();
        }
    }

    public static <E extends Exception> void sure(RunnableWithExceptions<E> runner) {
        try {
            runner.run();
        }
        catch (Exception exception) {
            LambdaExceptionUtil.throwAsUnchecked(exception);
            throw new UnreachableException();
        }
    }

    private static <E extends Exception> void throwAsUnchecked(Exception exception) throws E {
        throw exception;
    }

    private static class UnreachableException
    extends RuntimeException {
        private UnreachableException() {
        }
    }

    @FunctionalInterface
    public static interface BiPredicateWithExceptions<T, U, E extends Exception> {
        public boolean test(T var1, U var2) throws E;
    }

    @FunctionalInterface
    public static interface PredicateWithExceptions<T, E extends Exception> {
        public boolean test(T var1) throws E;
    }

    @FunctionalInterface
    public static interface RunnableWithExceptions<E extends Exception> {
        public void run() throws E;
    }

    @FunctionalInterface
    public static interface SupplierWithExceptions<T, E extends Exception> {
        public T get() throws E;
    }

    @FunctionalInterface
    public static interface BiFunctionWithExceptions<T, U, R, E extends Exception> {
        public R apply(T var1, U var2) throws E;
    }

    @FunctionalInterface
    public static interface FunctionWithExceptions<T, R, E extends Exception> {
        public R apply(T var1) throws E;
    }

    @FunctionalInterface
    public static interface BiConsumerWithExceptions<T, U, E extends Exception> {
        public void accept(T var1, U var2) throws E;
    }

    @FunctionalInterface
    public static interface ConsumerWithExceptions<T, E extends Exception> {
        public void accept(T var1) throws E;
    }
}

