/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.auth.impl.persistence;

import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.utils.LogUtil;
import com.alibaba.nacos.persistence.configuration.condition.ConditionOnExternalStorage;
import com.alibaba.nacos.persistence.datasource.DataSourceService;
import com.alibaba.nacos.persistence.datasource.DynamicDataSource;
import com.alibaba.nacos.persistence.model.Page;
import com.alibaba.nacos.plugin.auth.impl.persistence.AuthPaginationHelper;
import com.alibaba.nacos.plugin.auth.impl.persistence.AuthRowMapperManager;
import com.alibaba.nacos.plugin.auth.impl.persistence.User;
import com.alibaba.nacos.plugin.auth.impl.persistence.UserPersistService;
import com.alibaba.nacos.plugin.auth.impl.persistence.extrnal.AuthExternalPaginationHelperImpl;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.context.annotation.Conditional;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.CannotGetJdbcConnectionException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;

@Conditional(value={ConditionOnExternalStorage.class})
@Component
public class ExternalUserPersistServiceImpl
implements UserPersistService {
    private JdbcTemplate jt;
    private String dataSourceType = "";
    private static final String PATTERN_STR = "*";

    @PostConstruct
    protected void init() {
        DataSourceService dataSource = DynamicDataSource.getInstance().getDataSource();
        this.jt = dataSource.getJdbcTemplate();
        this.dataSourceType = dataSource.getDataSourceType();
    }

    @Override
    public void createUser(String username, String password) {
        String sql = "INSERT INTO users (username, password, enabled) VALUES (?, ?, ?)";
        try {
            this.jt.update(sql, new Object[]{username, password, true});
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void deleteUser(String username) {
        String sql = "DELETE FROM users WHERE username=?";
        try {
            this.jt.update(sql, new Object[]{username});
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void updateUserPassword(String username, String password) {
        try {
            this.jt.update("UPDATE users SET password = ? WHERE username=?", new Object[]{password, username});
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public User findUserByUsername(String username) {
        String sql = "SELECT username,password FROM users WHERE username=? ";
        try {
            return (User)this.jt.queryForObject(sql, new Object[]{username}, AuthRowMapperManager.USER_ROW_MAPPER);
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
        catch (Exception e) {
            LogUtil.FATAL_LOG.error("[db-other-error]" + e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public Page<User> getUsers(int pageNo, int pageSize, String username) {
        AuthPaginationHelper<User> helper = this.createPaginationHelper();
        String sqlCountRows = "SELECT count(*) FROM users ";
        String sqlFetchRows = "SELECT username,password FROM users ";
        StringBuilder where = new StringBuilder(" WHERE 1 = 1 ");
        ArrayList<String> params = new ArrayList<String>();
        if (StringUtils.isNotBlank((String)username)) {
            where.append(" AND username = ? ");
            params.add(username);
        }
        try {
            Page pageInfo = helper.fetchPage(sqlCountRows + where, sqlFetchRows + where, params.toArray(), pageNo, pageSize, AuthRowMapperManager.USER_ROW_MAPPER);
            if (pageInfo == null) {
                pageInfo = new Page();
                pageInfo.setTotalCount(0);
                pageInfo.setPageItems(new ArrayList());
            }
            return pageInfo;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public List<String> findUserLikeUsername(String username) {
        String sql = "SELECT username FROM users WHERE username LIKE ?";
        List users = this.jt.queryForList(sql, (Object[])new String[]{String.format("%%%s%%", username)}, String.class);
        return users;
    }

    @Override
    public Page<User> findUsersLike4Page(String username, int pageNo, int pageSize) {
        String sqlCountRows = "SELECT count(*) FROM users ";
        String sqlFetchRows = "SELECT username,password FROM users ";
        StringBuilder where = new StringBuilder(" WHERE 1 = 1 ");
        ArrayList<String> params = new ArrayList<String>();
        if (StringUtils.isNotBlank((String)username)) {
            where.append(" AND username LIKE ? ");
            params.add(this.generateLikeArgument(username));
        }
        AuthPaginationHelper<User> helper = this.createPaginationHelper();
        try {
            return helper.fetchPage(sqlCountRows + where, sqlFetchRows + where, params.toArray(), pageNo, pageSize, AuthRowMapperManager.USER_ROW_MAPPER);
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public String generateLikeArgument(String s) {
        String underscore = "_";
        if (s.contains(underscore)) {
            s = s.replaceAll(underscore, "\\\\_");
        }
        String fuzzySearchSign = "\\*";
        String sqlLikePercentSign = "%";
        if (s.contains(PATTERN_STR)) {
            return s.replaceAll(fuzzySearchSign, sqlLikePercentSign);
        }
        return s;
    }

    @Override
    public <E> AuthPaginationHelper<E> createPaginationHelper() {
        return new AuthExternalPaginationHelperImpl(this.jt, this.dataSourceType);
    }
}

