/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service.dump.disk;

import com.alibaba.nacos.api.utils.StringUtils;
import com.alibaba.nacos.common.pathencoder.PathEncoderManager;
import com.alibaba.nacos.common.utils.IoUtils;
import com.alibaba.nacos.config.server.service.dump.disk.ConfigDiskService;
import com.alibaba.nacos.config.server.utils.LogUtil;
import com.alibaba.nacos.sys.env.EnvUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;

public class ConfigRawDiskService
implements ConfigDiskService {
    private static final String BASE_DIR = File.separator + "data" + File.separator + "config-data";
    private static final String TENANT_BASE_DIR = File.separator + "data" + File.separator + "tenant-config-data";
    private static final String BETA_DIR = File.separator + "data" + File.separator + "beta-data";
    private static final String TENANT_BETA_DIR = File.separator + "data" + File.separator + "tenant-beta-data";
    private static final String TAG_DIR = File.separator + "data" + File.separator + "tag-data";
    private static final String TENANT_TAG_DIR = File.separator + "data" + File.separator + "tenant-tag-data";
    private static final String BATCH_DIR = File.separator + "data" + File.separator + "batch-data";
    private static final String TENANT_BATCH_DIR = File.separator + "data" + File.separator + "tenant-batch-data";

    @Override
    public void saveToDisk(String dataId, String group, String tenant, String content) throws IOException {
        File targetFile = ConfigRawDiskService.targetFile(dataId, group, tenant);
        FileUtils.writeStringToFile((File)targetFile, (String)content, (String)"UTF-8");
    }

    private static File targetFile(String dataId, String group, String tenant) {
        dataId = PathEncoderManager.getInstance().encode(dataId);
        group = PathEncoderManager.getInstance().encode(group);
        tenant = PathEncoderManager.getInstance().encode(tenant);
        File file = null;
        if (StringUtils.isBlank((CharSequence)tenant)) {
            file = new File(EnvUtil.getNacosHome(), BASE_DIR);
        } else {
            file = new File(EnvUtil.getNacosHome(), TENANT_BASE_DIR);
            file = new File(file, tenant);
        }
        file = new File(file, group);
        file = new File(file, dataId);
        return file;
    }

    private static File targetBetaFile(String dataId, String group, String tenant) {
        dataId = PathEncoderManager.getInstance().encode(dataId);
        group = PathEncoderManager.getInstance().encode(group);
        tenant = PathEncoderManager.getInstance().encode(tenant);
        File file = null;
        if (StringUtils.isBlank((CharSequence)tenant)) {
            file = new File(EnvUtil.getNacosHome(), BETA_DIR);
        } else {
            file = new File(EnvUtil.getNacosHome(), TENANT_BETA_DIR);
            file = new File(file, tenant);
        }
        file = new File(file, group);
        file = new File(file, dataId);
        return file;
    }

    private static File targetTagFile(String dataId, String group, String tenant, String tag) {
        dataId = PathEncoderManager.getInstance().encode(dataId);
        group = PathEncoderManager.getInstance().encode(group);
        tenant = PathEncoderManager.getInstance().encode(tenant);
        File file = null;
        if (StringUtils.isBlank((CharSequence)tenant)) {
            file = new File(EnvUtil.getNacosHome(), TAG_DIR);
        } else {
            file = new File(EnvUtil.getNacosHome(), TENANT_TAG_DIR);
            file = new File(file, tenant);
        }
        file = new File(file, group);
        file = new File(file, dataId);
        file = new File(file, tag);
        return file;
    }

    @Override
    public void saveBetaToDisk(String dataId, String group, String tenant, String content) throws IOException {
        File targetFile = ConfigRawDiskService.targetBetaFile(dataId, group, tenant);
        FileUtils.writeStringToFile((File)targetFile, (String)content, (String)"UTF-8");
    }

    @Override
    public void saveTagToDisk(String dataId, String group, String tenant, String tag, String content) throws IOException {
        File targetFile = ConfigRawDiskService.targetTagFile(dataId, group, tenant, tag);
        FileUtils.writeStringToFile((File)targetFile, (String)content, (String)"UTF-8");
    }

    @Override
    public void removeConfigInfo(String dataId, String group, String tenant) {
        FileUtils.deleteQuietly((File)ConfigRawDiskService.targetFile(dataId, group, tenant));
    }

    @Override
    public void removeConfigInfo4Beta(String dataId, String group, String tenant) {
        FileUtils.deleteQuietly((File)ConfigRawDiskService.targetBetaFile(dataId, group, tenant));
    }

    @Override
    public void removeConfigInfo4Tag(String dataId, String group, String tenant, String tag) {
        FileUtils.deleteQuietly((File)ConfigRawDiskService.targetTagFile(dataId, group, tenant, tag));
    }

    private static String file2String(File file) throws IOException {
        if (!file.exists()) {
            return null;
        }
        return FileUtils.readFileToString((File)file, (String)"UTF-8");
    }

    @Override
    public String getBetaContent(String dataId, String group, String tenant) throws IOException {
        File file = ConfigRawDiskService.targetBetaFile(dataId, group, tenant);
        return ConfigRawDiskService.file2String(file);
    }

    @Override
    public String getTagContent(String dataId, String group, String tenant, String tag) throws IOException {
        File file = ConfigRawDiskService.targetTagFile(dataId, group, tenant, tag);
        return ConfigRawDiskService.file2String(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getContent(String dataId, String group, String tenant) throws IOException {
        File file = ConfigRawDiskService.targetFile(dataId, group, tenant);
        if (file.exists()) {
            String string;
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(file);
                string = IoUtils.toString((InputStream)fis, (String)"UTF-8");
            }
            catch (FileNotFoundException e) {
                String string2;
                try {
                    string2 = null;
                }
                catch (Throwable throwable) {
                    IoUtils.closeQuietly(fis);
                    throw throwable;
                }
                IoUtils.closeQuietly((Closeable)fis);
                return string2;
            }
            IoUtils.closeQuietly((Closeable)fis);
            return string;
        }
        return null;
    }

    @Override
    public void clearAll() {
        File file = new File(EnvUtil.getNacosHome(), BASE_DIR);
        if (!file.exists() || FileUtils.deleteQuietly((File)file)) {
            LogUtil.DEFAULT_LOG.info("clear all config-info success.");
        } else {
            LogUtil.DEFAULT_LOG.warn("clear all config-info failed.");
        }
        File fileTenant = new File(EnvUtil.getNacosHome(), TENANT_BASE_DIR);
        if (!fileTenant.exists() || FileUtils.deleteQuietly((File)fileTenant)) {
            LogUtil.DEFAULT_LOG.info("clear all config-info-tenant success.");
        } else {
            LogUtil.DEFAULT_LOG.warn("clear all config-info-tenant failed.");
        }
    }

    @Override
    public void clearAllBeta() {
        File file = new File(EnvUtil.getNacosHome(), BETA_DIR);
        if (!file.exists() || FileUtils.deleteQuietly((File)file)) {
            LogUtil.DEFAULT_LOG.info("clear all config-info-beta success.");
        } else {
            LogUtil.DEFAULT_LOG.warn("clear all config-info-beta failed.");
        }
        File fileTenant = new File(EnvUtil.getNacosHome(), TENANT_BETA_DIR);
        if (!fileTenant.exists() || FileUtils.deleteQuietly((File)fileTenant)) {
            LogUtil.DEFAULT_LOG.info("clear all config-info-beta-tenant success.");
        } else {
            LogUtil.DEFAULT_LOG.warn("clear all config-info-beta-tenant failed.");
        }
    }

    @Override
    public void clearAllTag() {
        File file = new File(EnvUtil.getNacosHome(), TAG_DIR);
        if (!file.exists() || FileUtils.deleteQuietly((File)file)) {
            LogUtil.DEFAULT_LOG.info("clear all config-info-tag success.");
        } else {
            LogUtil.DEFAULT_LOG.warn("clear all config-info-tag failed.");
        }
        File fileTenant = new File(EnvUtil.getNacosHome(), TENANT_TAG_DIR);
        if (!fileTenant.exists() || FileUtils.deleteQuietly((File)fileTenant)) {
            LogUtil.DEFAULT_LOG.info("clear all config-info-tag-tenant success.");
        } else {
            LogUtil.DEFAULT_LOG.warn("clear all config-info-tag-tenant failed.");
        }
    }
}

