/*
 * Decompiled with CFR 0.152.
 */
package io.github.rcarlosdasilva.weixin.api;

import com.google.common.base.Strings;
import com.google.common.io.ByteStreams;
import io.github.rcarlosdasilva.weixin.core.OpenPlatform;
import io.github.rcarlosdasilva.weixin.core.Registry;
import io.github.rcarlosdasilva.weixin.core.Weixin;
import io.github.rcarlosdasilva.weixin.core.exception.MaydayMaydaySaveMeBecauseAccessTokenSetMeFuckUpException;
import io.github.rcarlosdasilva.weixin.core.http.ContentType;
import io.github.rcarlosdasilva.weixin.core.http.FormData;
import io.github.rcarlosdasilva.weixin.core.http.Http;
import io.github.rcarlosdasilva.weixin.core.http.HttpMethod;
import io.github.rcarlosdasilva.weixin.core.http.MultiFile;
import io.github.rcarlosdasilva.weixin.core.parser.ResponseParser;
import io.github.rcarlosdasilva.weixin.model.request.base.Request;
import io.github.rcarlosdasilva.weixin.model.request.certificate.AccessTokenRequest;
import io.github.rcarlosdasilva.weixin.model.request.open.auth.OpenPlatformAuthAccessTokenRequest;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicApi {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final String accountKey;

    public BasicApi() {
        this.accountKey = null;
    }

    public BasicApi(String accountKey) {
        this.accountKey = accountKey;
    }

    private void updateAccessToken(Request requestModel) {
        if (!(requestModel instanceof AccessTokenRequest) && !(requestModel instanceof OpenPlatformAuthAccessTokenRequest)) {
            String accessToken = null;
            accessToken = Strings.isNullOrEmpty((String)this.accountKey) ? OpenPlatform.certificate().askAccessToken() : Weixin.with(this.accountKey).certificate().askAccessToken();
            requestModel.updateAccessToken(accessToken);
        }
    }

    protected <T> T post(final Class<T> target, final Request requestModel) {
        this.updateAccessToken(requestModel);
        return (T)new RetryableRunner<T>(){

            @Override
            <R> R pending() {
                String responseText = Http.requestWithBodyContent(requestModel.toUrl(), HttpMethod.POST, requestModel.toJson(), ContentType.JSON);
                Object response = ResponseParser.parse(target, responseText);
                return (R)response;
            }
        }.run();
    }

    protected InputStream postStream(final Request requestModel) {
        this.updateAccessToken(requestModel);
        return (InputStream)new RetryableRunner<InputStream>(){

            @Override
            <R> R pending() {
                return (R)Http.requestStreamWithBodyContent(requestModel.toUrl(), HttpMethod.POST, requestModel.toJson(), ContentType.JSON);
            }
        }.run();
    }

    protected <T> T get(final Class<T> target, final Request requestModel) {
        this.updateAccessToken(requestModel);
        return (T)new RetryableRunner<T>(){

            @Override
            <R> R pending() {
                String responseText = Http.requestWithBodyContent(requestModel.toUrl(), HttpMethod.GET, null, ContentType.JSON);
                return (R)ResponseParser.parse(target, responseText);
            }
        }.run();
    }

    protected InputStream getStream(final Request requestModel) {
        this.updateAccessToken(requestModel);
        return (InputStream)new RetryableRunner<InputStream>(){

            @Override
            <R> R pending() {
                return (R)Http.requestStreamWithBodyContent(requestModel.toUrl(), HttpMethod.GET, null, ContentType.JSON);
            }
        }.run();
    }

    protected <T> T upload(final Class<T> target, final Request requestModel, final String key, final String fileName, final File file, final List<FormData> additionalData) {
        this.updateAccessToken(requestModel);
        return (T)new RetryableRunner<T>(){

            @Override
            <R> R pending() {
                String responseText = Http.requestWithFile(requestModel.toUrl(), new MultiFile(key, fileName, file), (List<FormData>)additionalData);
                return (R)ResponseParser.parse(target, responseText);
            }
        }.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] readStream(InputStream is) {
        try {
            byte[] byArray = ByteStreams.toByteArray((InputStream)is);
            return byArray;
        }
        catch (IOException ex) {
            this.logger.error("weixin basic api", (Throwable)ex);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ex) {
                this.logger.error("weixin basic api", (Throwable)ex);
            }
        }
    }

    abstract class RetryableRunner<R> {
        private final Logger logger = LoggerFactory.getLogger(RetryableRunner.class);

        RetryableRunner() {
        }

        private int getRetryTimes() {
            return Registry.setting().getRetries();
        }

        private void refreshAccessToken() {
            Weixin.with(BasicApi.this.accountKey).certificate().refreshAccessToken();
        }

        R run() {
            int times = 0;
            R result = null;
            while (true) {
                try {
                    result = this.pending();
                }
                catch (MaydayMaydaySaveMeBecauseAccessTokenSetMeFuckUpException ex) {
                    this.logger.debug("weixin basic api", (Throwable)ex);
                    if (times++ >= this.getRetryTimes()) {
                        this.logger.error("For:{} >> \u5931\u8d25\uff01\u5df2\u5c1d\u8bd5\u91cd\u65b0\u6267\u884c{}\u6b21", (Object)BasicApi.this.accountKey, (Object)(times - 1));
                        break;
                    }
                    this.logger.error("For:{} >> \u5931\u8d25\uff01\u7b2c{}\u6b21\u5c1d\u8bd5\u91cd\u65b0\u6267\u884c", (Object)BasicApi.this.accountKey, (Object)times);
                    this.refreshAccessToken();
                    continue;
                }
                break;
            }
            return result;
        }

        abstract <R> R pending();
    }
}

