/*
 * Decompiled with CFR 0.152.
 */
package io.github.rcarlosdasilva.weixin.api.op.impl;

import com.google.common.base.Strings;
import io.github.rcarlosdasilva.weixin.api.BasicApi;
import io.github.rcarlosdasilva.weixin.api.op.OpCertificateApi;
import io.github.rcarlosdasilva.weixin.common.Utils;
import io.github.rcarlosdasilva.weixin.common.dictionary.ResultCode;
import io.github.rcarlosdasilva.weixin.core.OpenPlatform;
import io.github.rcarlosdasilva.weixin.core.Registry;
import io.github.rcarlosdasilva.weixin.core.cache.CacheHandler;
import io.github.rcarlosdasilva.weixin.core.cache.GeneralCacheableObject;
import io.github.rcarlosdasilva.weixin.core.exception.CanNotFetchOpenPlatformAccessTokenException;
import io.github.rcarlosdasilva.weixin.core.exception.CanNotFetchOpenPlatformPreAuthCodeException;
import io.github.rcarlosdasilva.weixin.core.exception.ExecuteException;
import io.github.rcarlosdasilva.weixin.core.exception.OpenPlatformNotFoundException;
import io.github.rcarlosdasilva.weixin.core.exception.OpenPlatformTicketNotFoundException;
import io.github.rcarlosdasilva.weixin.core.listener.OpenPlatformAccessTokenUpdatedListener;
import io.github.rcarlosdasilva.weixin.core.listener.OpenPlatformLisensorAccessTokenUpdatedListener;
import io.github.rcarlosdasilva.weixin.model.AccessToken;
import io.github.rcarlosdasilva.weixin.model.OpAccount;
import io.github.rcarlosdasilva.weixin.model.request.open.auth.OpenPlatformAuthAccessTokenRequest;
import io.github.rcarlosdasilva.weixin.model.request.open.auth.OpenPlatformAuthGetLicenseInformationRequest;
import io.github.rcarlosdasilva.weixin.model.request.open.auth.OpenPlatformAuthGetLicensorInformationRequest;
import io.github.rcarlosdasilva.weixin.model.request.open.auth.OpenPlatformAuthGetLicensorOptionRequest;
import io.github.rcarlosdasilva.weixin.model.request.open.auth.OpenPlatformAuthPreAuthCodeRequest;
import io.github.rcarlosdasilva.weixin.model.request.open.auth.OpenPlatformAuthRefreshLicensorAccessTokenRequest;
import io.github.rcarlosdasilva.weixin.model.request.open.auth.OpenPlatformAuthSetLicensorOptionRequest;
import io.github.rcarlosdasilva.weixin.model.request.open.auth.OpenPlatformResetQuotaRequest;
import io.github.rcarlosdasilva.weixin.model.response.open.auth.OpenPlatformAuthAccessTokenResponse;
import io.github.rcarlosdasilva.weixin.model.response.open.auth.OpenPlatformAuthGetLicenseInformationResponse;
import io.github.rcarlosdasilva.weixin.model.response.open.auth.OpenPlatformAuthGetLicensorOptionResponse;
import io.github.rcarlosdasilva.weixin.model.response.open.auth.OpenPlatformAuthPreAuthCodeResponse;
import io.github.rcarlosdasilva.weixin.model.response.open.auth.bean.LicensedAccessToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpCertificateApiImpl
extends BasicApi
implements OpCertificateApi {
    private final Logger logger = LoggerFactory.getLogger(OpCertificateApiImpl.class);

    private OpAccount getOpenPlatformInfo() {
        OpAccount openPlatform = Registry.openPlatform();
        if (openPlatform == null) {
            this.logger.warn("\u672a\u914d\u7f6e\u5fae\u4fe1\u5f00\u653e\u5e73\u53f0\u4fe1\u606f");
            throw new OpenPlatformNotFoundException();
        }
        return openPlatform;
    }

    @Override
    public String askAccessToken() {
        AccessToken token = CacheHandler.of(AccessToken.class).get("op_access_token");
        if (token != null && !token.isExpired()) {
            return token.getAccessToken();
        }
        if (null == token) {
            this.logger.debug("For: >> \u65e0\u7f13\u5b58\u8fc7\u7684component_access_token\uff0c\u8bf7\u6c42access_token");
        } else {
            this.logger.debug("For: >> \u56e0component_access_token\u8fc7\u671f\uff0c\u91cd\u65b0\u8bf7\u6c42\u3002\u5931\u6548\u7684access_token\uff1a[{}]", (Object)token.getAccessToken());
        }
        while ((token = CacheHandler.of(AccessToken.class).get("op_access_token")) == null || token.isExpired()) {
            String identifier = CacheHandler.of(AccessToken.class).lock("op_access_token", 2000L, true);
            if (Strings.isNullOrEmpty((String)identifier)) {
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            token = this.requestAccessToken();
            CacheHandler.of(AccessToken.class).unlock("op_access_token", identifier);
        }
        if (token == null) {
            this.logger.error("\u65e0\u6cd5\u83b7\u53d6\u5fae\u4fe1\u5f00\u653e\u5e73\u53f0\u7684component_access_token");
            throw new CanNotFetchOpenPlatformAccessTokenException();
        }
        return token.getAccessToken();
    }

    private synchronized AccessToken requestAccessToken() {
        this.logger.debug("For: >> \u6b63\u5728\u83b7\u53d6component_access_token");
        GeneralCacheableObject cacheableObject = CacheHandler.of(GeneralCacheableObject.class).get("op_ticket");
        String ticket = null;
        if (cacheableObject != null) {
            ticket = cacheableObject.getObj().toString();
        }
        if (Strings.isNullOrEmpty(ticket)) {
            this.logger.warn("\u83b7\u53d6\u4e0d\u5230\u5fae\u4fe1\u5f00\u653e\u5e73\u53f0\u7684ticket\uff0c\u53ef\u80fd\u5fae\u4fe1\u8fd8\u672a\u5c06ticket\u901a\u77e5\u5230\u5f53\u524d\u670d\u52a1\u5668");
            throw new OpenPlatformTicketNotFoundException();
        }
        OpAccount openPlatform = this.getOpenPlatformInfo();
        OpenPlatformAuthAccessTokenRequest requestModel = new OpenPlatformAuthAccessTokenRequest();
        requestModel.setAppId(openPlatform.getAppId());
        requestModel.setAppSecret(openPlatform.getAppSecret());
        requestModel.setTicket(ticket);
        AccessToken accessToken = this.post(OpenPlatformAuthAccessTokenResponse.class, requestModel);
        if (accessToken != null) {
            accessToken.setAccountMark("op_access_token");
            CacheHandler.of(AccessToken.class).put("op_access_token", accessToken);
            this.logger.debug("For: >> \u83b7\u53d6\u5230access_token\uff1a[{}]", (Object)accessToken.getAccessToken());
            OpenPlatformAccessTokenUpdatedListener listener = Registry.listener(OpenPlatformAccessTokenUpdatedListener.class);
            if (listener != null) {
                this.logger.debug("For: >> \u8c03\u7528\u76d1\u542c\u5668OpenPlatformAccessTokenUpdatedListener");
                listener.updated(accessToken.getAccessToken(), accessToken.getExpiresIn());
            }
            return accessToken;
        }
        return null;
    }

    @Override
    public String askPreAuthCode() {
        OpAccount openPlatform = this.getOpenPlatformInfo();
        OpenPlatformAuthPreAuthCodeRequest requestModel = new OpenPlatformAuthPreAuthCodeRequest();
        requestModel.setAppId(openPlatform.getAppId());
        OpenPlatformAuthPreAuthCodeResponse responseModel = this.post(OpenPlatformAuthPreAuthCodeResponse.class, requestModel);
        if (responseModel == null) {
            this.logger.error("\u65e0\u6cd5\u83b7\u53d6\u5fae\u4fe1\u5f00\u653e\u5e73\u53f0\u9884\u6388\u6743\u7801");
            throw new CanNotFetchOpenPlatformPreAuthCodeException();
        }
        return responseModel.getPreAuthCode();
    }

    @Override
    public OpenPlatformAuthGetLicenseInformationResponse getLicenseInformation(String license) {
        return this.getLicensingInformation(license);
    }

    @Override
    public OpenPlatformAuthGetLicenseInformationResponse getLicensingInformation(String license) {
        OpAccount openPlatform = this.getOpenPlatformInfo();
        OpenPlatformAuthGetLicenseInformationRequest requestModel = new OpenPlatformAuthGetLicenseInformationRequest();
        requestModel.setAppId(openPlatform.getAppId());
        requestModel.setAuthCode(license);
        OpenPlatformAuthGetLicenseInformationResponse responseModel = this.post(OpenPlatformAuthGetLicenseInformationResponse.class, requestModel);
        this.invokeListener(responseModel.getLicensingInformation().getAppId(), responseModel.getLicensedAccessToken());
        return responseModel;
    }

    @Override
    public OpenPlatformAuthGetLicenseInformationResponse refreshLicensorAccessToken(String licensoraAppId, String refreshToken) {
        OpAccount openPlatform = this.getOpenPlatformInfo();
        OpenPlatformAuthRefreshLicensorAccessTokenRequest requestModel = new OpenPlatformAuthRefreshLicensorAccessTokenRequest();
        requestModel.setAppId(openPlatform.getAppId());
        requestModel.setLicensorAppId(licensoraAppId);
        requestModel.setLicensorRefreshToken(refreshToken);
        OpenPlatformAuthGetLicenseInformationResponse responseModel = this.post(OpenPlatformAuthGetLicenseInformationResponse.class, requestModel);
        this.invokeListener(licensoraAppId, responseModel.getLicensedAccessToken());
        return responseModel;
    }

    private void invokeListener(String licensoraAppId, LicensedAccessToken licensedAccessToken) {
        OpenPlatformLisensorAccessTokenUpdatedListener listener = Registry.listener(OpenPlatformLisensorAccessTokenUpdatedListener.class);
        if (listener != null) {
            this.logger.debug("For: >> \u8c03\u7528\u76d1\u542c\u5668OpenPlatformLisensorAccessTokenUpdatedListener");
            listener.updated(licensoraAppId, licensedAccessToken.getAccessToken(), licensedAccessToken.getRefreshToken(), licensedAccessToken.getExpiresIn());
        }
    }

    @Override
    public OpenPlatformAuthGetLicenseInformationResponse getLicensorInformation(String licensoraAppId) {
        OpAccount openPlatform = this.getOpenPlatformInfo();
        OpenPlatformAuthGetLicensorInformationRequest requestModel = new OpenPlatformAuthGetLicensorInformationRequest();
        requestModel.setAppId(openPlatform.getAppId());
        requestModel.setLicensorAppId(licensoraAppId);
        return this.post(OpenPlatformAuthGetLicenseInformationResponse.class, requestModel);
    }

    @Override
    public OpenPlatformAuthGetLicensorOptionResponse getLicensorOption(String licensoraAppId, String optionName) {
        OpAccount openPlatform = this.getOpenPlatformInfo();
        OpenPlatformAuthGetLicensorOptionRequest requestModel = new OpenPlatformAuthGetLicensorOptionRequest();
        requestModel.setAppId(openPlatform.getAppId());
        requestModel.setLicensorAppId(licensoraAppId);
        requestModel.setOptionName(optionName);
        return this.post(OpenPlatformAuthGetLicensorOptionResponse.class, requestModel);
    }

    @Override
    public boolean setLicensorOption(String licensoraAppId, String optionName, String value) {
        OpAccount openPlatform = this.getOpenPlatformInfo();
        OpenPlatformAuthSetLicensorOptionRequest requestModel = new OpenPlatformAuthSetLicensorOptionRequest();
        requestModel.setAppId(openPlatform.getAppId());
        requestModel.setLicensorAppId(licensoraAppId);
        requestModel.setOptionName(optionName);
        requestModel.setValue(value);
        return this.post(Boolean.class, requestModel);
    }

    @Override
    public String openPlatformAuthorize(String redirectTo) {
        String preAuthCode = OpenPlatform.certificate().askPreAuthCode();
        OpAccount openPlatform = Registry.openPlatform();
        if (openPlatform == null) {
            this.logger.warn("\u672a\u914d\u7f6e\u5fae\u4fe1\u5f00\u653e\u5e73\u53f0\u4fe1\u606f");
            throw new OpenPlatformNotFoundException();
        }
        return "https://mp.weixin.qq.com/cgi-bin/componentloginpage" + "?component_appid=" + openPlatform.getAppId() + "&pre_auth_code=" + preAuthCode + "&redirect_uri=" + Utils.urlEncode(redirectTo);
    }

    @Override
    public boolean resetQuota() {
        OpenPlatformResetQuotaRequest requestModel = new OpenPlatformResetQuotaRequest();
        requestModel.setAppId(Registry.openPlatform().getAppId());
        try {
            return this.post(Boolean.class, requestModel);
        }
        catch (ExecuteException ex) {
            if (ex.getCode() != null && ex.getCode() == ResultCode.RESULT_48006) {
                return false;
            }
            throw ex;
        }
    }
}

