/*
 * Decompiled with CFR 0.152.
 */
package io.github.rcarlosdasilva.weixin.api.op.impl;

import com.google.common.base.Strings;
import io.github.rcarlosdasilva.weixin.api.BasicApi;
import io.github.rcarlosdasilva.weixin.api.op.OpWeixinCertificateApi;
import io.github.rcarlosdasilva.weixin.api.op.impl.OpCertificateApiImpl;
import io.github.rcarlosdasilva.weixin.common.Utils;
import io.github.rcarlosdasilva.weixin.common.dictionary.WebAuthorizeScope;
import io.github.rcarlosdasilva.weixin.core.Registry;
import io.github.rcarlosdasilva.weixin.core.exception.OpenPlatformNotFoundException;
import io.github.rcarlosdasilva.weixin.model.OpAccount;
import io.github.rcarlosdasilva.weixin.model.request.open.certificate.OpenCertificateWaAccessTokenRefreshRequest;
import io.github.rcarlosdasilva.weixin.model.request.open.certificate.OpenCertificateWaAccessTokenRequest;
import io.github.rcarlosdasilva.weixin.model.response.certificate.WaAccessTokenResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpWeixinCertificateApiImpl
extends BasicApi
implements OpWeixinCertificateApi {
    private final Logger logger = LoggerFactory.getLogger(OpCertificateApiImpl.class);

    private OpAccount getOpenPlatformInfo() {
        OpAccount openPlatform = Registry.openPlatform();
        if (openPlatform == null) {
            this.logger.warn("\u672a\u914d\u7f6e\u5fae\u4fe1\u5f00\u653e\u5e73\u53f0\u4fe1\u606f");
            throw new OpenPlatformNotFoundException();
        }
        return openPlatform;
    }

    @Override
    public String webAuthorize(String licensoraAppId, WebAuthorizeScope scope, String redirectTo, String param) {
        OpAccount openPlatform = this.getOpenPlatformInfo();
        return "https://open.weixin.qq.com/connect/oauth2/authorize" + "?appid=" + licensoraAppId + "&redirect_uri=" + Utils.urlEncode(redirectTo) + "&response_type=code&scope=" + (Object)((Object)scope) + (Strings.isNullOrEmpty((String)param) ? "" : "&state=" + param) + "&component_appid=" + openPlatform.getAppId() + "#wechat_redirect";
    }

    @Override
    public String webAuthorize(String licensoraAppId, WebAuthorizeScope scope, String redirectTo) {
        return this.webAuthorize(licensoraAppId, scope, redirectTo, null);
    }

    @Override
    public WaAccessTokenResponse askWebAuthorizeAccessToken(String appId, String code) {
        OpAccount openPlatform = this.getOpenPlatformInfo();
        OpenCertificateWaAccessTokenRequest requestModel = new OpenCertificateWaAccessTokenRequest();
        requestModel.setAppId(appId);
        requestModel.setCode(code);
        requestModel.setOpenPlatformAppId(openPlatform.getAppId());
        return this.get(WaAccessTokenResponse.class, requestModel);
    }

    @Override
    public WaAccessTokenResponse refreshWebAuthorizeAccessToken(String appId, String refreshToken) {
        OpAccount openPlatform = this.getOpenPlatformInfo();
        OpenCertificateWaAccessTokenRefreshRequest requestModel = new OpenCertificateWaAccessTokenRefreshRequest();
        requestModel.setAppId(appId);
        requestModel.setRefreshToken(refreshToken);
        requestModel.setOpenPlatformAppId(openPlatform.getAppId());
        return this.get(WaAccessTokenResponse.class, requestModel);
    }
}

