/*
 * Decompiled with CFR 0.152.
 */
package io.github.rcarlosdasilva.weixin.api.weixin.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.github.rcarlosdasilva.weixin.api.BasicApi;
import io.github.rcarlosdasilva.weixin.api.weixin.CertificateApi;
import io.github.rcarlosdasilva.weixin.common.Utils;
import io.github.rcarlosdasilva.weixin.common.dictionary.WebAuthorizeScope;
import io.github.rcarlosdasilva.weixin.core.OpenPlatform;
import io.github.rcarlosdasilva.weixin.core.Registry;
import io.github.rcarlosdasilva.weixin.core.Weixin;
import io.github.rcarlosdasilva.weixin.core.cache.CacheHandler;
import io.github.rcarlosdasilva.weixin.core.exception.CanNotFetchAccessTokenException;
import io.github.rcarlosdasilva.weixin.core.exception.CanNotFetchOpenPlatformLicensorAccessTokenException;
import io.github.rcarlosdasilva.weixin.core.exception.InvalidAccountException;
import io.github.rcarlosdasilva.weixin.core.exception.LostWeixinLicensedRefreshTokenException;
import io.github.rcarlosdasilva.weixin.core.json.Json;
import io.github.rcarlosdasilva.weixin.core.listener.AccessTokenUpdatedListener;
import io.github.rcarlosdasilva.weixin.core.listener.JsTicketUpdatedListener;
import io.github.rcarlosdasilva.weixin.model.AccessToken;
import io.github.rcarlosdasilva.weixin.model.JsTicket;
import io.github.rcarlosdasilva.weixin.model.JsapiSignature;
import io.github.rcarlosdasilva.weixin.model.WeixinAccount;
import io.github.rcarlosdasilva.weixin.model.request.certificate.AccessTokenRequest;
import io.github.rcarlosdasilva.weixin.model.request.certificate.JsTicketRequest;
import io.github.rcarlosdasilva.weixin.model.request.certificate.WaAccessTokenRefreshRequest;
import io.github.rcarlosdasilva.weixin.model.request.certificate.WaAccessTokenRequest;
import io.github.rcarlosdasilva.weixin.model.request.certificate.WaAccessTokenVerifyRequest;
import io.github.rcarlosdasilva.weixin.model.response.certificate.AccessTokenResponse;
import io.github.rcarlosdasilva.weixin.model.response.certificate.JsTicketResponse;
import io.github.rcarlosdasilva.weixin.model.response.certificate.WaAccessTokenResponse;
import io.github.rcarlosdasilva.weixin.model.response.open.auth.OpenPlatformAuthGetLicenseInformationResponse;
import io.github.rcarlosdasilva.weixin.model.response.open.auth.bean.LicensedAccessToken;
import java.util.UUID;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateApiImpl
extends BasicApi
implements CertificateApi {
    private final Logger logger = LoggerFactory.getLogger(CertificateApiImpl.class);

    public CertificateApiImpl(String accountKey) {
        super(accountKey);
    }

    @Override
    public synchronized String askAccessToken() {
        AccessToken token = CacheHandler.of(AccessToken.class).get(this.accountKey);
        if (token != null && !token.isExpired()) {
            return token.getAccessToken();
        }
        if (null == token) {
            this.logger.debug("For:{} >> \u65e0\u7f13\u5b58\u8fc7\u7684access_token\uff0c\u8bf7\u6c42access_token", (Object)this.accountKey);
        } else {
            this.logger.debug("For:{} >> \u56e0access_token\u8fc7\u671f\uff0c\u91cd\u65b0\u8bf7\u6c42\u3002\u5931\u6548\u7684access_token\uff1a[{}]", (Object)this.accountKey, (Object)token);
        }
        WeixinAccount account = Registry.lookup(this.accountKey);
        if (account == null) {
            throw new InvalidAccountException();
        }
        while ((token = CacheHandler.of(AccessToken.class).get(this.accountKey)) == null || token.isExpired()) {
            String identifier = CacheHandler.of(AccessToken.class).lock(this.accountKey, 2000L, true);
            if (Strings.isNullOrEmpty((String)identifier)) {
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            if (account.isWithOpenPlatform()) {
                String refreshToken = null == token ? account.getRefreshToken() : token.getRefreshToken();
                token = this.refreshLicensedAccessToken(account.getAppId(), refreshToken);
            } else {
                token = this.requestAccessToken();
            }
            CacheHandler.of(AccessToken.class).unlock(this.accountKey, identifier);
        }
        if (token == null) {
            this.logger.error("\u65e0\u6cd5\u83b7\u53d6\u5fae\u4fe1\u516c\u4f17\u53f7\u7684access_token");
            throw new CanNotFetchAccessTokenException();
        }
        return token.getAccessToken();
    }

    @Override
    public void refreshAccessToken() {
        this.requestAccessToken();
    }

    @Override
    public void updateAccessToken(String token, long expiredAt) {
        if (Strings.isNullOrEmpty((String)token) || expiredAt < 0L) {
            this.logger.warn("For:{} >> \u4f7f\u7528\u9519\u8bef\u7684\u6570\u636e\u66f4\u65b0token\uff1a {}, {}", new Object[]{this.accountKey, token, expiredAt});
            return;
        }
        long expiresIn = 0x6DDD00L;
        if (expiredAt > 0L) {
            expiresIn = expiredAt - System.currentTimeMillis();
        }
        String responseMock = String.format("{'access_token':'%s','expires_in':%s}", token, expiresIn / 1000L);
        AccessToken accessToken = Json.fromJson(responseMock, AccessTokenResponse.class);
        accessToken.setAccountMark(this.accountKey);
        CacheHandler.of(AccessToken.class).put(this.accountKey, accessToken);
    }

    private synchronized AccessToken refreshLicensedAccessToken(String licensorAppId, String refreshToken) {
        Preconditions.checkNotNull((Object)licensorAppId);
        if (Strings.isNullOrEmpty((String)refreshToken)) {
            this.logger.error("\u627e\u4e0d\u5230\u6b63\u786e\u7684\u6388\u6743\u65b9access_token\u5237\u65b0\u4ee4\u724c\uff0c\u6216\u8bb8\u9700\u8981\u6388\u6743\u65b9\u91cd\u65b0\u6388\u6743");
            throw new LostWeixinLicensedRefreshTokenException();
        }
        OpenPlatformAuthGetLicenseInformationResponse response = OpenPlatform.certificate().refreshLicensorAccessToken(licensorAppId, refreshToken);
        if (response == null || Strings.isNullOrEmpty((String)response.getLicensedAccessToken().getAccessToken())) {
            this.logger.error("\u83b7\u53d6\u4e0d\u5230\u6388\u6743\u65b9\u7684access_token");
            throw new CanNotFetchOpenPlatformLicensorAccessTokenException();
        }
        LicensedAccessToken accessToken = response.getLicensedAccessToken();
        accessToken.setAccountMark(this.accountKey);
        CacheHandler.of(AccessToken.class).put(this.accountKey, accessToken);
        this.logger.debug("For:{} >> \u5f00\u653e\u5e73\u53f0\u66f4\u65b0\u6388\u6743\u65b9access_token\uff1a[{}]", (Object)this.accountKey, (Object)accessToken.getAccessToken());
        return accessToken;
    }

    private synchronized AccessToken requestAccessToken() {
        this.logger.debug("For:{} >> \u6b63\u5728\u83b7\u53d6access_token", (Object)this.accountKey);
        WeixinAccount account = Registry.lookup(this.accountKey);
        AccessTokenRequest requestModel = new AccessTokenRequest();
        requestModel.setAppId(account.getAppId());
        requestModel.setAppSecret(account.getAppSecret());
        AccessToken accessToken = this.get(AccessTokenResponse.class, requestModel);
        if (accessToken != null) {
            accessToken.setAccountMark(this.accountKey);
            CacheHandler.of(AccessToken.class).put(this.accountKey, accessToken);
            this.logger.debug("For:{} >> \u83b7\u53d6\u5230access_token\uff1a[{}]", (Object)this.accountKey, (Object)accessToken.getAccessToken());
            AccessTokenUpdatedListener listener = Registry.listener(AccessTokenUpdatedListener.class);
            if (listener != null) {
                this.logger.debug("For:{} >> \u8c03\u7528\u76d1\u542c\u5668AccessTokenUpdatedListener", (Object)this.accountKey);
                listener.updated(account.getKey(), account.getAppId(), accessToken.getAccessToken(), accessToken.getExpiresIn());
            }
            return accessToken;
        }
        return null;
    }

    @Override
    public final String askJsTicket() {
        JsTicket ticket = CacheHandler.of(JsTicket.class).get(this.accountKey);
        if (ticket != null && !ticket.isExpired()) {
            return ticket.getJsTicket();
        }
        if (null == ticket) {
            this.logger.debug("For:{} >> \u65e0\u7f13\u5b58\u8fc7\u7684jsapi_ticket\uff0c\u8bf7\u6c42jsapi_ticket", (Object)this.accountKey);
        } else {
            this.logger.debug("For:{} >> \u56e0jsapi_ticket\u8fc7\u671f\uff0c\u91cd\u65b0\u8bf7\u6c42\u3002\u5931\u6548\u7684jsapi_ticket\uff1a[{}]", (Object)this.accountKey, (Object)ticket);
        }
        while ((ticket = CacheHandler.of(JsTicket.class).get(this.accountKey)) == null || ticket.isExpired()) {
            String identifier = CacheHandler.of(JsTicket.class).lock(this.accountKey, 2000L, true);
            if (Strings.isNullOrEmpty((String)identifier)) {
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            ticket = this.requestJsTicket();
            CacheHandler.of(AccessToken.class).unlock(this.accountKey, identifier);
        }
        return null == ticket ? null : ticket.getJsTicket();
    }

    @Override
    public void refreshJsTicket() {
        this.requestJsTicket();
    }

    @Override
    public void updateJsTicket(String ticket, long expiredAt) {
        if (Strings.isNullOrEmpty((String)ticket) || expiredAt < 0L) {
            this.logger.warn("For:{} >> \u4f7f\u7528\u9519\u8bef\u7684\u6570\u636e\u66f4\u65b0ticket\uff1a {}, {}", new Object[]{this.accountKey, ticket, expiredAt});
            return;
        }
        long expiresIn = 0x6DDD00L;
        if (expiredAt > 0L) {
            expiresIn = expiredAt - System.currentTimeMillis();
        }
        String responseMock = String.format("{'access_token':'%s','expires_in':%s}", ticket, expiresIn / 1000L);
        JsTicketResponse responseModel = Json.fromJson(responseMock, JsTicketResponse.class);
        responseModel.updateExpireAt();
        CacheHandler.of(JsTicket.class).put(this.accountKey, responseModel);
    }

    private synchronized JsTicketResponse requestJsTicket() {
        this.logger.debug("For:{} >> \u6b63\u5728\u83b7\u53d6jsapi_ticket", (Object)this.accountKey);
        JsTicketRequest requestModel = new JsTicketRequest();
        JsTicketResponse responseModel = this.get(JsTicketResponse.class, requestModel);
        if (responseModel != null) {
            responseModel.updateExpireAt();
            CacheHandler.of(JsTicket.class).put(this.accountKey, responseModel);
            this.logger.debug("For:{} >> \u83b7\u53d6jsapi_ticket\uff1a[{}]", (Object)this.accountKey, (Object)responseModel.getJsTicket());
            JsTicketUpdatedListener listener = Registry.listener(JsTicketUpdatedListener.class);
            if (listener != null) {
                this.logger.debug("For:{} >> \u8c03\u7528\u76d1\u542c\u5668JsTicketUpdatedListener", (Object)this.accountKey);
                WeixinAccount account = Registry.lookup(this.accountKey);
                listener.updated(account.getKey(), account.getAppId(), responseModel.getJsTicket(), responseModel.getExpiresIn());
            }
            return responseModel;
        }
        return null;
    }

    @Override
    public WaAccessTokenResponse askWebAuthorizeAccessToken(String code) {
        WeixinAccount account = Registry.lookup(this.accountKey);
        WaAccessTokenRequest requestModel = new WaAccessTokenRequest();
        requestModel.setAppId(account.getAppId());
        requestModel.setAppSecret(account.getAppSecret());
        requestModel.setCode(code);
        return this.get(WaAccessTokenResponse.class, requestModel);
    }

    @Override
    public WaAccessTokenResponse refreshWebAuthorizeAccessToken(String refreshToken) {
        WeixinAccount account = Registry.lookup(this.accountKey);
        WaAccessTokenRefreshRequest requestModel = new WaAccessTokenRefreshRequest();
        requestModel.setAppId(account.getAppId());
        requestModel.setRefreshToken(refreshToken);
        return this.get(WaAccessTokenResponse.class, requestModel);
    }

    @Override
    public boolean verifyWebAuthorizeAccessToken(String accessToken, String openId) {
        WaAccessTokenVerifyRequest requestModel = new WaAccessTokenVerifyRequest();
        requestModel.setAccessToken(accessToken);
        requestModel.setOpenId(openId);
        return this.get(Boolean.class, requestModel);
    }

    @Override
    public String webAuthorize(WebAuthorizeScope scope, String redirectTo, String param) {
        WeixinAccount account = Registry.lookup(this.accountKey);
        return "https://open.weixin.qq.com/connect/oauth2/authorize" + "?appid=" + account.getAppId() + "&redirect_uri=" + Utils.urlEncode(redirectTo) + "&response_type=code&scope=" + (Object)((Object)scope) + (Strings.isNullOrEmpty((String)param) ? "" : "&state=" + param) + "#wechat_redirect";
    }

    @Override
    public String webAuthorize(WebAuthorizeScope scope, String redirectTo) {
        return this.webAuthorize(scope, redirectTo, null);
    }

    @Override
    public JsapiSignature generateJsapiSignature(String url) {
        WeixinAccount account = Registry.lookup(this.accountKey);
        String ticket = Weixin.with(this.accountKey).certificate().askJsTicket();
        String timestamp = Long.toString(System.currentTimeMillis() / 1000L);
        String nonce = UUID.randomUUID().toString();
        String raw = "jsapi_ticket=" + ticket + "&noncestr=" + nonce + "&timestamp=" + timestamp + "&url=" + url;
        String signature = null;
        signature = DigestUtils.sha1Hex((String)raw);
        return new JsapiSignature(account.getAppId(), ticket, signature, url, timestamp, nonce);
    }
}

