/*
 * Decompiled with CFR 0.152.
 */
package io.github.rcarlosdasilva.weixin.api.weixin.impl;

import io.github.rcarlosdasilva.weixin.api.BasicApi;
import io.github.rcarlosdasilva.weixin.api.weixin.HelperApi;
import io.github.rcarlosdasilva.weixin.common.dictionary.ResultCode;
import io.github.rcarlosdasilva.weixin.core.Registry;
import io.github.rcarlosdasilva.weixin.core.Weixin;
import io.github.rcarlosdasilva.weixin.core.cache.CacheHandler;
import io.github.rcarlosdasilva.weixin.core.cache.GeneralCacheableObject;
import io.github.rcarlosdasilva.weixin.core.exception.ExecuteException;
import io.github.rcarlosdasilva.weixin.model.request.helper.HelperResetQuotaRequest;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HelperApiImpl
extends BasicApi
implements HelperApi {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public HelperApiImpl(String accountKey) {
        super(accountKey);
    }

    @Override
    public boolean resetQuota() {
        HelperResetQuotaRequest requestModel = new HelperResetQuotaRequest();
        requestModel.setAppId(Registry.lookup(this.accountKey).getAppId());
        try {
            return this.post(Boolean.class, requestModel);
        }
        catch (ExecuteException ex) {
            if (ex.getCode() != null && ex.getCode() == ResultCode.RESULT_48006) {
                return false;
            }
            throw ex;
        }
    }

    @Override
    public boolean isLegalRequestIp(String ip) {
        List<String> ips;
        GeneralCacheableObject cacheableObject = CacheHandler.of(GeneralCacheableObject.class).get("wick");
        if (cacheableObject != null) {
            ips = (List<String>)cacheableObject.getObj();
        } else {
            ips = Weixin.with(this.accountKey).common().getWeixinIps();
            CacheHandler.of(GeneralCacheableObject.class).put("wick", new GeneralCacheableObject(ips));
        }
        return ips.contains(ip.trim());
    }

    @Override
    public boolean isUsable() {
        try {
            Weixin.with(this.accountKey).certificate().askAccessToken();
            return true;
        }
        catch (Exception ex) {
            this.logger.trace("weixin helper api", (Throwable)ex);
            return false;
        }
    }
}

