/*
 * Decompiled with CFR 0.152.
 */
package io.github.rcarlosdasilva.weixin.api.weixin.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.rcarlosdasilva.weixin.api.BasicApi;
import io.github.rcarlosdasilva.weixin.api.weixin.MaterialApi;
import io.github.rcarlosdasilva.weixin.common.dictionary.MediaType;
import io.github.rcarlosdasilva.weixin.core.http.ContentType;
import io.github.rcarlosdasilva.weixin.core.http.FormData;
import io.github.rcarlosdasilva.weixin.core.http.Http;
import io.github.rcarlosdasilva.weixin.core.http.HttpMethod;
import io.github.rcarlosdasilva.weixin.core.parser.ResponseParser;
import io.github.rcarlosdasilva.weixin.model.request.media.MediaAddMassImageRequest;
import io.github.rcarlosdasilva.weixin.model.request.media.MediaAddMassNewsRequest;
import io.github.rcarlosdasilva.weixin.model.request.media.MediaAddTemporaryRequest;
import io.github.rcarlosdasilva.weixin.model.request.media.MediaAddTimelessNewsRequest;
import io.github.rcarlosdasilva.weixin.model.request.media.MediaAddTimelessRequest;
import io.github.rcarlosdasilva.weixin.model.request.media.MediaCountTimelessRequest;
import io.github.rcarlosdasilva.weixin.model.request.media.MediaDeleteTimelessRequest;
import io.github.rcarlosdasilva.weixin.model.request.media.MediaGetTemporaryRequest;
import io.github.rcarlosdasilva.weixin.model.request.media.MediaGetTemporaryWithHqAudioRequest;
import io.github.rcarlosdasilva.weixin.model.request.media.MediaGetTimelessRequest;
import io.github.rcarlosdasilva.weixin.model.request.media.MediaListTimelessRequest;
import io.github.rcarlosdasilva.weixin.model.request.media.MediaTransformMassVideoRequest;
import io.github.rcarlosdasilva.weixin.model.request.media.MediaUpdateTimelessNewsRequest;
import io.github.rcarlosdasilva.weixin.model.request.media.bean.Article;
import io.github.rcarlosdasilva.weixin.model.response.media.MediaAddMassResponse;
import io.github.rcarlosdasilva.weixin.model.response.media.MediaAddTemporaryResponse;
import io.github.rcarlosdasilva.weixin.model.response.media.MediaAddTimelessResponse;
import io.github.rcarlosdasilva.weixin.model.response.media.MediaCountTimelessResponse;
import io.github.rcarlosdasilva.weixin.model.response.media.MediaGetTemporaryWithVideoResponse;
import io.github.rcarlosdasilva.weixin.model.response.media.MediaGetTimelessResponse;
import io.github.rcarlosdasilva.weixin.model.response.media.MediaListTimelessResponse;
import io.github.rcarlosdasilva.weixin.model.response.media.MediaTransformMassVideoResponse;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaterialApiImpl
extends BasicApi
implements MaterialApi {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public MaterialApiImpl(String accountKey) {
        super(accountKey);
    }

    @Override
    public MediaAddTemporaryResponse addTemporaryMedia(MediaType type, String fileName, File file) {
        Preconditions.checkArgument((MediaType.NEWS != type ? 1 : 0) != 0, (Object)"Not supported media type of News when add temporary");
        MediaAddTemporaryRequest requestModel = new MediaAddTemporaryRequest();
        requestModel.setType(type.getText());
        return this.upload(MediaAddTemporaryResponse.class, requestModel, "media", fileName, file, null);
    }

    @Override
    public byte[] getTemporaryMedia(String mediaId) {
        MediaGetTemporaryRequest requestModel = new MediaGetTemporaryRequest();
        requestModel.setMediaId(mediaId);
        InputStream is = this.getStream(requestModel);
        byte[] result = this.readStream(is);
        String text = new String(result);
        try {
            is.close();
            MediaGetTemporaryWithVideoResponse vedioResponse = ResponseParser.parse(MediaGetTemporaryWithVideoResponse.class, text);
            is = Http.requestStreamWithBodyContent(vedioResponse.getVideoUrl(), HttpMethod.GET, null, ContentType.JSON);
            result = this.readStream(is);
            is.close();
        }
        catch (Exception ex) {
            this.logger.debug("media api get temporary media", (Throwable)ex);
        }
        return result;
    }

    @Override
    public byte[] getTemporaryMediaWithHqAudio(String mediaId) {
        MediaGetTemporaryWithHqAudioRequest requestModel = new MediaGetTemporaryWithHqAudioRequest();
        requestModel.setMediaId(mediaId);
        return this.readStream(this.getStream(requestModel));
    }

    @Override
    public MediaAddTimelessResponse addTimelessMedia(MediaType type, String fileName, File file) {
        Preconditions.checkArgument((MediaType.VIDEO != type ? 1 : 0) != 0, (Object)"Please invoke addTimelessMediaVideo for upload vedio");
        MediaAddTimelessRequest requestModel = new MediaAddTimelessRequest();
        requestModel.setType(type.getText());
        return this.upload(MediaAddTimelessResponse.class, requestModel, "media", fileName, file, null);
    }

    @Override
    public MediaAddTimelessResponse addTimelessMediaVideo(String fileName, File file, String title, String description) {
        MediaAddTimelessRequest requestModel = new MediaAddTimelessRequest();
        requestModel.setType(MediaType.VIDEO.getText());
        JsonObject obj = new JsonObject();
        obj.addProperty("title", title);
        obj.addProperty("description", description);
        FormData data = new FormData("description", obj.toString());
        return this.upload(MediaAddTimelessResponse.class, requestModel, "media", fileName, file, Lists.newArrayList((Object[])new FormData[]{data}));
    }

    @Override
    public String addTimelessMediaNews(List<Article> articles) {
        MediaAddTimelessNewsRequest requestModel = new MediaAddTimelessNewsRequest();
        requestModel.setArticles(articles);
        MediaAddTimelessResponse responseModel = this.post(MediaAddTimelessResponse.class, requestModel);
        return null == responseModel ? null : responseModel.getMediaId();
    }

    @Override
    public MediaGetTimelessResponse getTimelessMedia(String mediaId) {
        MediaGetTimelessRequest requestModel = new MediaGetTimelessRequest();
        requestModel.setMediaId(mediaId);
        MediaGetTimelessResponse responseModel = null;
        try {
            responseModel = this.post(MediaGetTimelessResponse.class, requestModel);
        }
        catch (JsonSyntaxException ex) {
            this.logger.info("Json\u5b57\u7b26\u4e32\u89e3\u6790\u9519\u8bef\uff0c\u5c1d\u8bd5\u83b7\u53d6\u4e8c\u8fdb\u5236\u6d41\uff08\u6587\u4ef6\uff09\uff0c\u53ef\u80fd\u662f\u5728\u83b7\u53d6\u6c38\u4e45\u56fe\u7247\u3001\u97f3\u9891\u7d20\u6750");
            responseModel = new MediaGetTimelessResponse();
            responseModel.setStream(this.readStream(this.postStream(requestModel)));
        }
        return responseModel;
    }

    @Override
    public boolean deleteTimelessMedia(String mediaId) {
        MediaDeleteTimelessRequest requestModel = new MediaDeleteTimelessRequest();
        requestModel.setMediaId(mediaId);
        return this.post(Boolean.class, requestModel);
    }

    @Override
    public boolean updateTimelessMedia(String mediaId, int index, Article article) {
        MediaUpdateTimelessNewsRequest requestModel = new MediaUpdateTimelessNewsRequest();
        requestModel.setMediaId(mediaId);
        requestModel.setIndex(index);
        requestModel.setArticle(article);
        return this.post(Boolean.class, requestModel);
    }

    @Override
    public MediaCountTimelessResponse countTimelessMedia() {
        MediaCountTimelessRequest requestModel = new MediaCountTimelessRequest();
        return this.get(MediaCountTimelessResponse.class, requestModel);
    }

    @Override
    public MediaListTimelessResponse listTimelessMedia(MediaType type, int offset, int count) {
        Preconditions.checkArgument((MediaType.THUMBNAIL != type ? 1 : 0) != 0, (Object)"Not supported media type of Thumb when list timeless");
        if (count > 20) {
            count = 20;
        }
        if (count < 1) {
            count = 1;
        }
        MediaListTimelessRequest requestModel = new MediaListTimelessRequest();
        requestModel.setType(type.getText());
        requestModel.setOffset(offset);
        requestModel.setCount(count);
        return this.post(MediaListTimelessResponse.class, requestModel);
    }

    @Override
    public String addMassMediaImage(String fileName, File file) {
        MediaAddMassImageRequest requestModel = new MediaAddMassImageRequest();
        MediaAddMassResponse responseModel = this.upload(MediaAddMassResponse.class, requestModel, "media", fileName, file, null);
        return null == responseModel ? null : responseModel.getUrl();
    }

    @Override
    public MediaAddMassResponse addMassMediaNews(List<Article> articles) {
        MediaAddMassNewsRequest requestModel = new MediaAddMassNewsRequest();
        requestModel.setArticles(articles);
        return this.post(MediaAddMassResponse.class, requestModel);
    }

    @Override
    public MediaTransformMassVideoResponse transformMassMediaVideo(String mediaId, String title, String description) {
        MediaTransformMassVideoRequest requestModel = new MediaTransformMassVideoRequest();
        requestModel.setMediaId(mediaId);
        requestModel.setTitle(title);
        requestModel.setDescription(description);
        return this.post(MediaTransformMassVideoResponse.class, requestModel);
    }
}

