/*
 * Decompiled with CFR 0.152.
 */
package io.github.rcarlosdasilva.weixin.api.weixin.impl;

import com.google.common.base.Preconditions;
import io.github.rcarlosdasilva.weixin.api.BasicApi;
import io.github.rcarlosdasilva.weixin.api.weixin.MenuApi;
import io.github.rcarlosdasilva.weixin.model.request.menu.MenuCreateRequest;
import io.github.rcarlosdasilva.weixin.model.request.menu.MenuDeleteRequest;
import io.github.rcarlosdasilva.weixin.model.request.menu.MenuQueryCompleteRequest;
import io.github.rcarlosdasilva.weixin.model.request.menu.MenuQueryRequest;
import io.github.rcarlosdasilva.weixin.model.request.menu.MenuTestRequest;
import io.github.rcarlosdasilva.weixin.model.request.menu.bean.Menu;
import io.github.rcarlosdasilva.weixin.model.response.menu.MenuCompleteResponse;
import io.github.rcarlosdasilva.weixin.model.response.menu.MenuCreateResponse;
import io.github.rcarlosdasilva.weixin.model.response.menu.MenuInfoResponse;

public class MenuApiImpl
extends BasicApi
implements MenuApi {
    public MenuApiImpl(String accountKey) {
        super(accountKey);
    }

    @Override
    public boolean create(Menu menu) {
        Preconditions.checkNotNull((Object)menu);
        Preconditions.checkNotNull(menu.getButtons());
        MenuCreateRequest requestModel = new MenuCreateRequest();
        requestModel.setButtons(menu.getButtons());
        return this.post(Boolean.class, requestModel);
    }

    @Override
    public long createWithConditional(Menu menu) {
        Preconditions.checkNotNull((Object)menu);
        Preconditions.checkNotNull(menu.getButtons());
        Preconditions.checkNotNull((Object)menu.getMatchRule());
        MenuCreateRequest requestModel = new MenuCreateRequest();
        requestModel.setButtons(menu.getButtons());
        requestModel.setMatchRule(menu.getMatchRule());
        requestModel.withConditional();
        MenuCreateResponse responseModel = this.post(MenuCreateResponse.class, requestModel);
        return responseModel == null ? -1L : responseModel.getMenuId();
    }

    @Override
    public MenuInfoResponse query() {
        MenuQueryRequest requestModel = new MenuQueryRequest();
        return this.get(MenuInfoResponse.class, requestModel);
    }

    @Override
    public boolean delete() {
        MenuDeleteRequest requestModel = new MenuDeleteRequest();
        return this.get(Boolean.class, requestModel);
    }

    @Override
    public boolean deleteWithConditional(long menuId) {
        MenuDeleteRequest requestModel = new MenuDeleteRequest();
        requestModel.setMenuId(menuId);
        requestModel.withConditional();
        return this.post(Boolean.class, requestModel);
    }

    @Override
    public MenuInfoResponse testWithConditional(String userLabel) {
        MenuTestRequest requestModel = new MenuTestRequest();
        requestModel.setUserLabel(userLabel);
        return this.post(MenuInfoResponse.class, requestModel);
    }

    @Override
    public MenuCompleteResponse queryComplete() {
        MenuQueryCompleteRequest requestModel = new MenuQueryCompleteRequest();
        return this.get(MenuCompleteResponse.class, requestModel);
    }
}

