/*
 * Decompiled with CFR 0.152.
 */
package io.github.rcarlosdasilva.weixin.api.weixin.impl;

import com.google.common.base.Preconditions;
import io.github.rcarlosdasilva.weixin.api.BasicApi;
import io.github.rcarlosdasilva.weixin.api.weixin.StatisticsApi;
import io.github.rcarlosdasilva.weixin.model.request.statistics.StatisticsGetRequest;
import io.github.rcarlosdasilva.weixin.model.response.statistics.StatisticsGetInterfaceSummaryResponse;
import io.github.rcarlosdasilva.weixin.model.response.statistics.StatisticsGetMessageDistributedResponse;
import io.github.rcarlosdasilva.weixin.model.response.statistics.StatisticsGetMessageSummaryResponse;
import io.github.rcarlosdasilva.weixin.model.response.statistics.StatisticsGetNewsSummaryResponse;
import io.github.rcarlosdasilva.weixin.model.response.statistics.StatisticsGetUserSummaryResponse;
import java.util.Date;

public class StatisticsApiImpl
extends BasicApi
implements StatisticsApi {
    public StatisticsApiImpl(String accountKey) {
        super(accountKey);
    }

    @Override
    public StatisticsGetUserSummaryResponse getUserSummary(Date begin, Date end) {
        StatisticsGetRequest requestModel = this.setupRequestModel(begin, end);
        requestModel.forUserSummary();
        return this.post(StatisticsGetUserSummaryResponse.class, requestModel);
    }

    @Override
    public StatisticsGetUserSummaryResponse getUserCumulate(Date begin, Date end) {
        StatisticsGetRequest requestModel = this.setupRequestModel(begin, end);
        requestModel.forUserCumulate();
        return this.post(StatisticsGetUserSummaryResponse.class, requestModel);
    }

    @Override
    public StatisticsGetNewsSummaryResponse getNewsSummary(Date begin, Date end) {
        StatisticsGetRequest requestModel = this.setupRequestModel(begin, end);
        requestModel.forNewsSummary();
        return this.post(StatisticsGetNewsSummaryResponse.class, requestModel);
    }

    @Override
    public StatisticsGetNewsSummaryResponse getNewsTotal(Date begin, Date end) {
        StatisticsGetRequest requestModel = this.setupRequestModel(begin, end);
        requestModel.forNewsTotal();
        return this.post(StatisticsGetNewsSummaryResponse.class, requestModel);
    }

    @Override
    public StatisticsGetNewsSummaryResponse getNewsRead(Date begin, Date end) {
        StatisticsGetRequest requestModel = this.setupRequestModel(begin, end);
        requestModel.forNewsRead();
        return this.post(StatisticsGetNewsSummaryResponse.class, requestModel);
    }

    @Override
    public StatisticsGetNewsSummaryResponse getNewsReadHour(Date begin, Date end) {
        StatisticsGetRequest requestModel = this.setupRequestModel(begin, end);
        requestModel.forNewsReadHour();
        return this.post(StatisticsGetNewsSummaryResponse.class, requestModel);
    }

    @Override
    public StatisticsGetNewsSummaryResponse getNewsShare(Date begin, Date end) {
        StatisticsGetRequest requestModel = this.setupRequestModel(begin, end);
        requestModel.forNewsShare();
        return this.post(StatisticsGetNewsSummaryResponse.class, requestModel);
    }

    @Override
    public StatisticsGetNewsSummaryResponse getNewsShareHour(Date begin, Date end) {
        StatisticsGetRequest requestModel = this.setupRequestModel(begin, end);
        requestModel.forNewsShareHour();
        return this.post(StatisticsGetNewsSummaryResponse.class, requestModel);
    }

    @Override
    public StatisticsGetMessageSummaryResponse getMessageSummary(Date begin, Date end) {
        StatisticsGetRequest requestModel = this.setupRequestModel(begin, end);
        requestModel.forMessageSummary();
        return this.post(StatisticsGetMessageSummaryResponse.class, requestModel);
    }

    @Override
    public StatisticsGetMessageSummaryResponse getMessageSummaryHour(Date begin, Date end) {
        StatisticsGetRequest requestModel = this.setupRequestModel(begin, end);
        requestModel.forMessageHour();
        return this.post(StatisticsGetMessageSummaryResponse.class, requestModel);
    }

    @Override
    public StatisticsGetMessageSummaryResponse getMessageSummaryMonth(Date begin, Date end) {
        StatisticsGetRequest requestModel = this.setupRequestModel(begin, end);
        requestModel.forMessageWeek();
        return this.post(StatisticsGetMessageSummaryResponse.class, requestModel);
    }

    @Override
    public StatisticsGetMessageSummaryResponse getMessageSummaryWeek(Date begin, Date end) {
        StatisticsGetRequest requestModel = this.setupRequestModel(begin, end);
        requestModel.forMessageMonth();
        return this.post(StatisticsGetMessageSummaryResponse.class, requestModel);
    }

    @Override
    public StatisticsGetMessageDistributedResponse getMessageDistributed(Date begin, Date end) {
        StatisticsGetRequest requestModel = this.setupRequestModel(begin, end);
        requestModel.forMessageDistributed();
        return this.post(StatisticsGetMessageDistributedResponse.class, requestModel);
    }

    @Override
    public StatisticsGetMessageDistributedResponse getMessageDistributedMonth(Date begin, Date end) {
        StatisticsGetRequest requestModel = this.setupRequestModel(begin, end);
        requestModel.forMessageDistributedWeek();
        return this.post(StatisticsGetMessageDistributedResponse.class, requestModel);
    }

    @Override
    public StatisticsGetMessageDistributedResponse getMessageDistributedWeek(Date begin, Date end) {
        StatisticsGetRequest requestModel = this.setupRequestModel(begin, end);
        requestModel.forMessageDistributedMonth();
        return this.post(StatisticsGetMessageDistributedResponse.class, requestModel);
    }

    @Override
    public StatisticsGetInterfaceSummaryResponse getInterfaceSummary(Date begin, Date end) {
        StatisticsGetRequest requestModel = this.setupRequestModel(begin, end);
        requestModel.forInterfaceSummary();
        return this.post(StatisticsGetInterfaceSummaryResponse.class, requestModel);
    }

    @Override
    public StatisticsGetInterfaceSummaryResponse getInterfaceSummaryHour(Date begin, Date end) {
        StatisticsGetRequest requestModel = this.setupRequestModel(begin, end);
        requestModel.forInterfaceSummaryHour();
        return this.post(StatisticsGetInterfaceSummaryResponse.class, requestModel);
    }

    private StatisticsGetRequest setupRequestModel(Date begin, Date end) {
        Preconditions.checkArgument((boolean)begin.before(end), (Object)"Begin time should be before end time");
        StatisticsGetRequest requestModel = new StatisticsGetRequest();
        requestModel.setBegin(begin);
        requestModel.setEnd(end);
        return requestModel;
    }
}

