/*
 * Decompiled with CFR 0.152.
 */
package io.github.rcarlosdasilva.weixin.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Formatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger LOGGER = LoggerFactory.getLogger(Utils.class);

    private Utils() {
    }

    public static String urlEncode(String url) {
        try {
            return URLEncoder.encode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            LOGGER.error("weixin utils", (Throwable)ex);
            return null;
        }
    }

    public static String byteToHex(byte[] bytes) {
        Formatter formatter = new Formatter();
        for (byte b : bytes) {
            formatter.format("%02x", b);
        }
        String result = formatter.toString();
        formatter.close();
        return result;
    }

    public static <T> byte[] serialize(T object) {
        if (object == null) {
            return null;
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(object);
            byte[] result = baos.toByteArray();
            oos.close();
            baos.close();
            return result;
        }
        catch (Exception ex) {
            LOGGER.error("weixin utils", (Throwable)ex);
            return null;
        }
    }

    public static <T> T unserialize(byte[] bytes) {
        if (bytes == null || bytes.length <= 0) {
            return null;
        }
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            ObjectInputStream ois = new ObjectInputStream(bais);
            Object result = ois.readObject();
            ois.close();
            bais.close();
            return (T)result;
        }
        catch (Exception ex) {
            LOGGER.error("weixin utils", (Throwable)ex);
            return null;
        }
    }
}

