/*
 * Decompiled with CFR 0.152.
 */
package io.github.rcarlosdasilva.weixin.common.dictionary;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum NotificationEventType {
    CLICK("click"),
    VIEW("view"),
    SCAN_QR_PUSH("scancode_push"),
    SCAN_QR_WAIT_MSG("scancode_waitmsg"),
    PIC_PHOTO("pic_sysphoto"),
    PIC_PHOTO_OR_ALBUM("pic_photo_or_album"),
    PIC_WX_ALBUM("pic_weixin"),
    LOCATION("location_select"),
    SUBSCRIBE("subscribe"),
    UNSUBSCRIBE("unsubscribe"),
    SCAN("scan"),
    REPORT_LOCATION("location"),
    MASS_SEND_FINISH("masssendjobfinish"),
    TEMPLATE_SEND_FINISH("templatesendjobfinish"),
    VERIFY_QUALIFICATION_SUCCESS("qualification_verify_success"),
    VERIFY_QUALIFICATION_FAIL("qualification_verify_fail"),
    VERIFY_NAMING_SUCCESS("naming_verify_success"),
    VERIFY_NAMING_FAIL("naming_verify_fail"),
    VERIFY_ANNUAL("annual_renew"),
    VERIFY_EXPIRED("verify_expired"),
    CARD_PAID("User_pay_from_pay_cell"),
    UNKNOWN("");

    private static final Logger LOGGER;
    private String text;

    private NotificationEventType(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public String toString() {
        return this.text;
    }

    public static NotificationEventType byValue(String text) {
        for (NotificationEventType result : NotificationEventType.values()) {
            if (!result.text.equalsIgnoreCase(text)) continue;
            return result;
        }
        LOGGER.warn("No matching result for [{}]", (Object)text);
        return UNKNOWN;
    }

    static {
        LOGGER = LoggerFactory.getLogger(NotificationEventType.class);
    }
}

