/*
 * Decompiled with CFR 0.152.
 */
package io.github.rcarlosdasilva.weixin.common.dictionary;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum NotificationMessageType {
    EVENT("event"),
    TEXT("text"),
    IMAGE("image"),
    VOICE("voice"),
    VIDEO("video"),
    SHORT_VIDEO("shortvideo"),
    LOCATION("location"),
    LINK("link");

    private static final Logger LOGGER;
    private String text;

    private NotificationMessageType(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public String toString() {
        return this.text;
    }

    public static NotificationMessageType byValue(String text) {
        for (NotificationMessageType result : NotificationMessageType.values()) {
            if (!result.text.equalsIgnoreCase(text)) continue;
            return result;
        }
        LOGGER.warn("No matching result for [{}]", (Object)text);
        return null;
    }

    static {
        LOGGER = LoggerFactory.getLogger(NotificationMessageType.class);
    }
}

