/*
 * Decompiled with CFR 0.152.
 */
package io.github.rcarlosdasilva.weixin.core;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import io.github.rcarlosdasilva.weixin.core.cache.CacheHandler;
import io.github.rcarlosdasilva.weixin.core.cache.Lookup;
import io.github.rcarlosdasilva.weixin.core.exception.InvalidAccountException;
import io.github.rcarlosdasilva.weixin.core.listener.AccessTokenUpdatedListener;
import io.github.rcarlosdasilva.weixin.core.listener.JsTicketUpdatedListener;
import io.github.rcarlosdasilva.weixin.core.listener.OpenPlatformAccessTokenUpdatedListener;
import io.github.rcarlosdasilva.weixin.core.listener.OpenPlatformLisensorAccessTokenUpdatedListener;
import io.github.rcarlosdasilva.weixin.core.listener.WeixinListener;
import io.github.rcarlosdasilva.weixin.core.setting.Setting;
import io.github.rcarlosdasilva.weixin.model.AccessToken;
import io.github.rcarlosdasilva.weixin.model.OpAccount;
import io.github.rcarlosdasilva.weixin.model.WeixinAccount;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Registry {
    private static RegistryHandler registryHandler = new RegistryHandler();

    private Registry() {
        throw new IllegalStateException("Registry class");
    }

    public static RegistryHandler handler() {
        return registryHandler;
    }

    public static void withSetting(Setting setting) {
        Preconditions.checkNotNull((Object)setting);
        registryHandler.setSetting(setting);
    }

    public static Setting setting() {
        return registryHandler.getSetting();
    }

    public static void openPlatform(String componentAppId, String componentAppSecret, String token, String aesKey) {
        registryHandler.setOpAccount(new OpAccount(componentAppId, componentAppSecret, token, aesKey));
    }

    public static OpAccount openPlatform() {
        return registryHandler.getOpAccount();
    }

    public static void checkin(WeixinAccount account) {
        registryHandler.add(account);
    }

    public static void update(WeixinAccount account) {
        registryHandler.set(account);
    }

    public static void remove(String key) {
        registryHandler.del(key);
    }

    public static WeixinAccount lookup(String key) {
        return registryHandler.get(key);
    }

    public static boolean exists(String key) {
        return registryHandler.get(key) != null;
    }

    public static void listener(WeixinListener listener) {
        registryHandler.addListener(listener);
    }

    public static <T extends WeixinListener> T listener(Class<T> classType) {
        return registryHandler.getListener(classType);
    }

    public static class RegistryHandler {
        private final Logger logger = LoggerFactory.getLogger(this.getClass());
        private Setting setting = new Setting();
        private OpAccount opAccount;
        private Map<String, WeixinListener> listeners = Maps.newHashMap();

        RegistryHandler() {
        }

        Setting getSetting() {
            return this.setting;
        }

        void setSetting(Setting setting) {
            this.setting = setting;
        }

        OpAccount getOpAccount() {
            return this.opAccount;
        }

        void setOpAccount(OpAccount opAccount) {
            this.opAccount = opAccount;
        }

        void addListener(WeixinListener listener) {
            Preconditions.checkNotNull((Object)listener);
            if (listener instanceof AccessTokenUpdatedListener) {
                this.listeners.put(AccessTokenUpdatedListener.class.getName(), listener);
            } else if (listener instanceof JsTicketUpdatedListener) {
                this.listeners.put(JsTicketUpdatedListener.class.getName(), listener);
            } else if (listener instanceof OpenPlatformAccessTokenUpdatedListener) {
                this.listeners.put(OpenPlatformAccessTokenUpdatedListener.class.getName(), listener);
            } else if (listener instanceof OpenPlatformLisensorAccessTokenUpdatedListener) {
                this.listeners.put(OpenPlatformLisensorAccessTokenUpdatedListener.class.getName(), listener);
            }
        }

        <T extends WeixinListener> T getListener(Class<T> classType) {
            try {
                return (T)this.listeners.get(classType.getName());
            }
            catch (Exception ex) {
                this.logger.error("weixin config listener", (Throwable)ex);
                return null;
            }
        }

        void add(WeixinAccount account) {
            if (this.get(account.getKey()) != null) {
                this.logger.warn("\u5c1d\u8bd5\u6dfb\u52a0\u4e00\u4e2a\u5df2\u7ecf\u5b58\u5728\u7684\u516c\u4f17\u53f7\u4fe1\u606f\uff1a[{}]\uff0c\u672c\u65b9\u6cd5\u65e0\u6cd5\u8986\u76d6\u5df2\u6709\u516c\u4f17\u53f7\u4fe1\u606f\uff0c\u8bf7\u4f7f\u7528update\u65b9\u6cd5", (Object)account.getKey());
                return;
            }
            if (this.verify(account)) {
                CacheHandler.of(WeixinAccount.class).put(account.getKey(), account);
                this.logger.info("\u6ce8\u518c\u516c\u4f17\u53f7\uff1a[KEY: {}, APPID: {}]", (Object)account.getKey(), (Object)account.getAppId());
            }
        }

        void set(WeixinAccount account) {
            if (this.verify(account)) {
                this.del(account.getKey());
                CacheHandler.of(WeixinAccount.class).put(account.getKey(), account);
            }
        }

        void del(String key) {
            if (Strings.isNullOrEmpty((String)key)) {
                return;
            }
            WeixinAccount account = this.get(key);
            if (account != null) {
                String realKey = account.getKey();
                CacheHandler.of(WeixinAccount.class).remove(realKey);
                CacheHandler.of(AccessToken.class).remove(realKey);
                this.logger.info("\u5df2\u6ce8\u9500\u516c\u4f17\u53f7\u4fe1\u606f\uff1a[{}]", (Object)key);
            } else {
                this.logger.warn("\u672a\u627e\u5230\u53ef\u53d6\u6d88\u6ce8\u518c\u7684\u516c\u4f17\u53f7\u4fe1\u606f\uff1a[{}]", (Object)key);
            }
        }

        private boolean verify(WeixinAccount account) {
            if (account == null || Strings.isNullOrEmpty((String)account.getAppId())) {
                throw new InvalidAccountException();
            }
            if (!account.isWithOpenPlatform() && Strings.isNullOrEmpty((String)account.getAppSecret())) {
                this.logger.warn("\u672a\u627e\u5230\u516c\u4f17\u53f7\u7684app_scret\uff0c\u8be5\u516c\u4f17\u53f7\u5c06\u4e0d\u88ab\u6ce8\u518c");
                return false;
            }
            if (account.isWithOpenPlatform() && this.opAccount == null) {
                this.logger.warn("\u672a\u627e\u5230\u5f00\u653e\u5e73\u53f0\u4fe1\u606f\uff0c\u4f46\u8be5\u516c\u4f17\u53f7\u914d\u7f6e\u4e3a\u4f7f\u7528\u5f00\u653e\u5e73\u53f0\uff0c\u5c06\u4e0d\u88ab\u6ce8\u518c");
                return false;
            }
            if (account.isWithOpenPlatform() && Strings.isNullOrEmpty((String)account.getRefreshToken())) {
                this.logger.warn("\u672a\u627e\u5230\u5f00\u653e\u5e73\u53f0\u6388\u6743\u65b9\u7684\u5237\u65b0\u4ee4\u724cauthorizer_refresh_token\uff0c\u8be5\u516c\u4f17\u53f7\u5c06\u4e0d\u88ab\u6ce8\u518c");
                return false;
            }
            if (Strings.isNullOrEmpty((String)account.getMpId())) {
                this.logger.warn("\u672a\u8bbe\u7f6eAccount.mpId\uff0c\u5bf9\u516c\u4f17\u53f7appid: [{}]\u6765\u8bf4\uff0c\u5f53\u5fae\u4fe1\u901a\u77e5\u56de\u8c03\u6216\u5176\u4ed6\u64cd\u4f5c\u7684\u65f6\u5019\uff0c\u4e0d\u8bbe\u7f6e\u53ef\u80fd\u4f1a\u5bfc\u81f4\u65e0\u6cd5\u6b63\u786e\u627e\u5230\u5bf9\u5e94\u7684\u516c\u4f17\u53f7\u4fe1\u606f", (Object)account.getAppId());
            }
            if (Strings.isNullOrEmpty((String)account.getKey())) {
                this.logger.warn("\u672a\u8bbe\u7f6eAccount.key\uff0c\u5c06\u4f7f\u7528\u516c\u4f17\u53f7\u7684appid\uff1a[{}]\u4f5c\u4e3a\u9ed8\u8ba4key", (Object)account.getAppId());
                account.withKey(account.getAppId());
            }
            return true;
        }

        WeixinAccount get(String key) {
            if (Strings.isNullOrEmpty((String)key)) {
                return null;
            }
            WeixinAccount account = CacheHandler.of(WeixinAccount.class).get(key);
            if (account != null) {
                return account;
            }
            final String shrotKey = key;
            return CacheHandler.of(WeixinAccount.class).lookup(new Lookup<WeixinAccount>(){

                @Override
                public boolean isYou(String key, WeixinAccount obj) {
                    return shrotKey.equals(obj.getAppId()) || shrotKey.equals(obj.getMpId());
                }
            });
        }
    }
}

