/*
 * Decompiled with CFR 0.152.
 */
package io.github.rcarlosdasilva.weixin.core;

import com.google.common.collect.Maps;
import io.github.rcarlosdasilva.weixin.api.weixin.CertificateApi;
import io.github.rcarlosdasilva.weixin.api.weixin.CommentApi;
import io.github.rcarlosdasilva.weixin.api.weixin.CommonApi;
import io.github.rcarlosdasilva.weixin.api.weixin.CustomerServiceApi;
import io.github.rcarlosdasilva.weixin.api.weixin.HelperApi;
import io.github.rcarlosdasilva.weixin.api.weixin.MaterialApi;
import io.github.rcarlosdasilva.weixin.api.weixin.MenuApi;
import io.github.rcarlosdasilva.weixin.api.weixin.MessageApi;
import io.github.rcarlosdasilva.weixin.api.weixin.StatisticsApi;
import io.github.rcarlosdasilva.weixin.api.weixin.TemplateApi;
import io.github.rcarlosdasilva.weixin.api.weixin.UserApi;
import io.github.rcarlosdasilva.weixin.api.weixin.UserTagApi;
import io.github.rcarlosdasilva.weixin.api.weixin.impl.CertificateApiImpl;
import io.github.rcarlosdasilva.weixin.api.weixin.impl.CommentApiImpl;
import io.github.rcarlosdasilva.weixin.api.weixin.impl.CommonApiImpl;
import io.github.rcarlosdasilva.weixin.api.weixin.impl.CustomerServiceApiImpl;
import io.github.rcarlosdasilva.weixin.api.weixin.impl.HelperApiImpl;
import io.github.rcarlosdasilva.weixin.api.weixin.impl.MaterialApiImpl;
import io.github.rcarlosdasilva.weixin.api.weixin.impl.MenuApiImpl;
import io.github.rcarlosdasilva.weixin.api.weixin.impl.MessageApiImpl;
import io.github.rcarlosdasilva.weixin.api.weixin.impl.StatisticsApiImpl;
import io.github.rcarlosdasilva.weixin.api.weixin.impl.TemplateApiImpl;
import io.github.rcarlosdasilva.weixin.api.weixin.impl.UserApiImpl;
import io.github.rcarlosdasilva.weixin.api.weixin.impl.UserTagApiImpl;
import io.github.rcarlosdasilva.weixin.core.Registry;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Weixin {
    private static final Logger LOGGER = LoggerFactory.getLogger(Weixin.class);
    private static final Map<String, Weixin> HOLDER = Maps.newHashMap();
    private final CertificateApi certificate;
    private final CommonApi common;
    private final CustomerServiceApi customerService;
    private final HelperApi helper;
    private final UserApi user;
    private final UserTagApi userTag;
    private final MaterialApi material;
    private final CommentApi comment;
    private final MenuApi menu;
    private final MessageApi message;
    private final StatisticsApi statistics;
    private final TemplateApi template;

    private Weixin(String key) {
        this.certificate = new CertificateApiImpl(key);
        this.common = new CommonApiImpl(key);
        this.customerService = new CustomerServiceApiImpl(key);
        this.helper = new HelperApiImpl(key);
        this.user = new UserApiImpl(key);
        this.userTag = new UserTagApiImpl(key);
        this.material = new MaterialApiImpl(key);
        this.comment = new CommentApiImpl(key);
        this.menu = new MenuApiImpl(key);
        this.message = new MessageApiImpl(key);
        this.statistics = new StatisticsApiImpl(key);
        this.template = new TemplateApiImpl(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Weixin with(String key) {
        Weixin weixin = HOLDER.get(key);
        if (weixin == null) {
            if (Registry.exists(key)) {
                Map<String, Weixin> map = HOLDER;
                synchronized (map) {
                    HOLDER.put(key, new Weixin(key));
                }
            } else {
                LOGGER.warn("\u5c1d\u8bd5\u83b7\u53d6\u4e00\u4e2a\u672a\u6ce8\u518c\u7684\u516c\u4f17\u53f7API\u5165\u53e3\uff1a{}", (Object)key);
            }
        }
        return HOLDER.get(key);
    }

    public CertificateApi certificate() {
        return this.certificate;
    }

    public CommonApi common() {
        return this.common;
    }

    public CustomerServiceApi customerService() {
        return this.customerService;
    }

    public HelperApi helper() {
        return this.helper;
    }

    public UserApi user() {
        return this.user;
    }

    public UserTagApi userTag() {
        return this.userTag;
    }

    public MaterialApi material() {
        return this.material;
    }

    public CommentApi comment() {
        return this.comment;
    }

    public MenuApi menu() {
        return this.menu;
    }

    public MessageApi message() {
        return this.message;
    }

    public StatisticsApi statistics() {
        return this.statistics;
    }

    public TemplateApi template() {
        return this.template;
    }
}

