/*
 * Decompiled with CFR 0.152.
 */
package io.github.rcarlosdasilva.weixin.core.cache;

import com.google.common.collect.Maps;
import io.github.rcarlosdasilva.weixin.core.Registry;
import io.github.rcarlosdasilva.weixin.core.cache.CacheStorage;
import io.github.rcarlosdasilva.weixin.core.cache.CacheType;
import io.github.rcarlosdasilva.weixin.core.cache.Cacheable;
import io.github.rcarlosdasilva.weixin.core.cache.storage.JdkMapStorage;
import io.github.rcarlosdasilva.weixin.core.cache.storage.SimpleRedisStorage;
import io.github.rcarlosdasilva.weixin.core.cache.storage.SpringRedisStorage;
import io.github.rcarlosdasilva.weixin.core.cache.storage.redis.RedisHandler;
import java.lang.reflect.Field;
import java.util.Map;

public class CacheHandler {
    public static final String CACHEABLE_CLASS_GROUP_MARK_FIELD_NAME = "GROUP_NAME";
    private static final Map<Class<? extends Cacheable>, CacheStorage<? extends Cacheable>> STORAGES = Maps.newHashMap();

    private CacheHandler() {
        throw new IllegalStateException("CacheHandler class");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <V extends Cacheable> CacheStorage<V> of(Class<V> clazz) {
        CacheStorage<Cacheable> storage = STORAGES.get(clazz);
        if (storage == null) {
            Map<Class<? extends Cacheable>, CacheStorage<? extends Cacheable>> map = STORAGES;
            synchronized (map) {
                storage = CacheHandler.newStorage(clazz);
                STORAGES.put(clazz, storage);
            }
        }
        return storage;
    }

    private static <V extends Cacheable> CacheStorage<V> newStorage(Class<V> clazz) {
        String group = CacheHandler.groupName(clazz);
        CacheType cacheType = Registry.setting().getCacheType();
        if (cacheType == CacheType.SMART) {
            cacheType = CacheHandler.smartCacheType();
        }
        switch (cacheType) {
            case SPRING_REDIS: {
                return new SpringRedisStorage(group);
            }
            case SIMPLE_REDIS: {
                return new SimpleRedisStorage(group);
            }
            case JDK_MAP: {
                return new JdkMapStorage();
            }
        }
        return null;
    }

    private static CacheType smartCacheType() {
        if (RedisHandler.getRedisTemplate() != null) {
            return CacheType.SPRING_REDIS;
        }
        try {
            Class.forName("redis.clients.jedis.Jedis");
            return CacheType.SIMPLE_REDIS;
        }
        catch (Exception ex) {
            return CacheType.SIMPLE_REDIS;
        }
    }

    private static String groupName(Class<?> clazz) {
        try {
            Field field = clazz.getField(CACHEABLE_CLASS_GROUP_MARK_FIELD_NAME);
            return field.get(clazz).toString();
        }
        catch (Exception ex) {
            String clazzName = clazz.getSimpleName();
            int length = clazzName.length();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < length; ++i) {
                char c = clazzName.charAt(i);
                if (c >= 'a' && c <= 'z') {
                    sb.append(c);
                    continue;
                }
                if (c < 'A' || c > 'Z') continue;
                if (i > 0) {
                    sb.append('_');
                }
                c = (char)(c + 32);
                sb.append(c);
            }
            return sb.toString();
        }
    }
}

