/*
 * Decompiled with CFR 0.152.
 */
package io.github.rcarlosdasilva.weixin.core.cache.storage;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.github.rcarlosdasilva.weixin.core.cache.CacheStorage;
import io.github.rcarlosdasilva.weixin.core.cache.Cacheable;
import io.github.rcarlosdasilva.weixin.core.cache.Lookup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public final class JdkMapStorage<V extends Cacheable>
implements CacheStorage<V> {
    private final Map<String, V> cache = Maps.newConcurrentMap();

    @Override
    public Collection<String> keys() {
        return this.cache.keySet();
    }

    @Override
    public int size() {
        return this.cache.size();
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Override
    public boolean exists(String key) {
        if (Strings.isNullOrEmpty((String)key)) {
            return false;
        }
        return this.cache.containsKey(key);
    }

    @Override
    public V get(String key) {
        if (Strings.isNullOrEmpty((String)key)) {
            return null;
        }
        return (V)((Cacheable)this.cache.get(key));
    }

    @Override
    public V put(String key, V object) {
        return (V)((Cacheable)this.cache.put(key, object));
    }

    @Override
    public V put(String key, V object, int timeout) {
        return this.put(key, object);
    }

    @Override
    public boolean remove(String key) {
        this.cache.remove(key);
        return true;
    }

    @Override
    public V lookup(Lookup<V> lookup) {
        Collection<String> keys = this.keys();
        for (String key : keys) {
            V obj;
            if (!lookup.isYou(key, obj = this.get(key))) continue;
            return obj;
        }
        return null;
    }

    @Override
    public List<V> lookupAll(Lookup<V> lookup) {
        Collection<String> keys = this.keys();
        ArrayList result = Lists.newArrayList();
        for (String key : keys) {
            V obj;
            if (!lookup.isYou(key, obj = this.get(key))) continue;
            result.add(obj);
        }
        return result;
    }

    @Override
    public String lock(String key, long timeout, boolean noWait) {
        return null;
    }

    @Override
    public boolean unlock(String key, String identifier) {
        return false;
    }
}

