/*
 * Decompiled with CFR 0.152.
 */
package io.github.rcarlosdasilva.weixin.core.cache.storage;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import io.github.rcarlosdasilva.weixin.common.Utils;
import io.github.rcarlosdasilva.weixin.core.cache.CacheStorage;
import io.github.rcarlosdasilva.weixin.core.cache.Cacheable;
import io.github.rcarlosdasilva.weixin.core.cache.Lookup;
import io.github.rcarlosdasilva.weixin.core.cache.storage.redis.RedisHandler;
import io.github.rcarlosdasilva.weixin.core.cache.storage.redis.RedisKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Transaction;

public class SimpleRedisStorage<V extends Cacheable>
implements CacheStorage<V> {
    private String group;
    private String keyPattern;

    public SimpleRedisStorage(String group) {
        this.group = group;
        this.keyPattern = RedisKey.fullKey(group, "*");
    }

    @Override
    public Collection<String> keys() {
        Jedis jedis = RedisHandler.getJedis();
        Set keys = jedis.keys(this.keyPattern);
        jedis.close();
        return new ArrayList<String>(keys);
    }

    @Override
    public int size() {
        return this.keys().size();
    }

    @Override
    public void clear() {
        Jedis jedis = RedisHandler.getJedis();
        Set keys = jedis.keys(this.keyPattern);
        if (keys != null && !keys.isEmpty()) {
            jedis.del(keys.toArray(new String[keys.size()]));
        }
        jedis.close();
    }

    @Override
    public boolean exists(String key) {
        if (Strings.isNullOrEmpty((String)key)) {
            return false;
        }
        String fullKey = RedisKey.fullKey(this.group, key);
        Jedis jedis = RedisHandler.getJedis();
        boolean exists = jedis.exists(fullKey.getBytes());
        jedis.close();
        return exists;
    }

    @Override
    public V get(String key) {
        if (Strings.isNullOrEmpty((String)key)) {
            return null;
        }
        String fullKey = RedisKey.fullKey(this.group, key);
        Jedis jedis = RedisHandler.getJedis();
        byte[] value = jedis.get(fullKey.getBytes());
        jedis.close();
        if (value == null) {
            return null;
        }
        return (V)((Cacheable)Utils.unserialize(value));
    }

    @Override
    public V put(String key, V object) {
        Preconditions.checkNotNull((Object)key);
        Jedis jedis = RedisHandler.getJedis();
        String fullKey = RedisKey.fullKey(this.group, key);
        String code = jedis.set(fullKey.getBytes(), Utils.serialize(object));
        jedis.close();
        if ("OK".equalsIgnoreCase(code)) {
            return object;
        }
        return null;
    }

    @Override
    public V put(String key, V object, int timeout) {
        Preconditions.checkNotNull((Object)key);
        Jedis jedis = RedisHandler.getJedis();
        String fullKey = RedisKey.fullKey(this.group, key);
        String code = jedis.setex(fullKey.getBytes(), timeout, Utils.serialize(object));
        jedis.close();
        if ("OK".equalsIgnoreCase(code)) {
            return object;
        }
        return null;
    }

    @Override
    public boolean remove(String key) {
        if (Strings.isNullOrEmpty((String)key)) {
            return false;
        }
        String fullKey = RedisKey.fullKey(this.group, key);
        Jedis jedis = RedisHandler.getJedis();
        long result = jedis.del(fullKey);
        jedis.close();
        return result > 0L;
    }

    @Override
    public V lookup(Lookup<V> lookup) {
        Collection<String> keys = this.keys();
        Jedis jedis = RedisHandler.getJedis();
        for (String key : keys) {
            Cacheable obj;
            byte[] value = jedis.get(key.getBytes());
            if (value == null || !lookup.isYou(key, obj = (Cacheable)Utils.unserialize(value))) continue;
            jedis.close();
            return (V)obj;
        }
        jedis.close();
        return null;
    }

    @Override
    public List<V> lookupAll(Lookup<V> lookup) {
        Collection<String> keys = this.keys();
        ArrayList result = Lists.newArrayList();
        Jedis jedis = RedisHandler.getJedis();
        for (String key : keys) {
            Cacheable obj;
            byte[] value = jedis.get(key.getBytes());
            if (value == null || !lookup.isYou(key, obj = (Cacheable)Utils.unserialize(value))) continue;
            result.add(obj);
        }
        jedis.close();
        return result;
    }

    @Override
    public String lock(String key, long timeout, boolean noWait) {
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkArgument((timeout > 0L ? 1 : 0) != 0);
        String fullKey = RedisKey.fullKey(this.group, key) + "__lock";
        String identifier = UUID.randomUUID().toString();
        long lastTtl = -1L;
        Jedis jedis = RedisHandler.getJedis();
        while (true) {
            if (jedis.setnx(fullKey, identifier) == 1L) break;
            long ttl = jedis.pttl(fullKey);
            if (ttl == -1L) {
                jedis.pexpire(fullKey, timeout);
            } else {
                if (ttl == -2L) continue;
                if (lastTtl > 0L && ttl > lastTtl) {
                    jedis.close();
                    return null;
                }
                lastTtl = ttl;
            }
            if (noWait) {
                jedis.close();
                return null;
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        jedis.pexpire(fullKey, timeout);
        jedis.close();
        return identifier;
    }

    @Override
    public boolean unlock(String key, String identifier) {
        Jedis jedis;
        block1: {
            List results;
            Preconditions.checkNotNull((Object)key);
            Preconditions.checkNotNull((Object)identifier);
            String fullKey = RedisKey.fullKey(this.group, key) + "__lock";
            jedis = RedisHandler.getJedis();
            do {
                jedis.watch(new String[]{fullKey});
                if (!identifier.equals(jedis.get(fullKey))) break block1;
                Transaction transaction = jedis.multi();
                transaction.del(fullKey);
                results = transaction.exec();
            } while (results == null);
            jedis.close();
            return true;
        }
        jedis.unwatch();
        jedis.close();
        return false;
    }
}

