/*
 * Decompiled with CFR 0.152.
 */
package io.github.rcarlosdasilva.weixin.core.cache.storage;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import io.github.rcarlosdasilva.weixin.core.cache.CacheStorage;
import io.github.rcarlosdasilva.weixin.core.cache.Cacheable;
import io.github.rcarlosdasilva.weixin.core.cache.Lookup;
import io.github.rcarlosdasilva.weixin.core.cache.storage.redis.RedisHandler;
import io.github.rcarlosdasilva.weixin.core.cache.storage.redis.RedisKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.SessionCallback;

public class SpringRedisStorage<V extends Cacheable>
implements CacheStorage<V> {
    private String group;
    private String keyPattern;

    public SpringRedisStorage(String group) {
        this.group = group;
        this.keyPattern = RedisKey.fullKey(group, "*");
    }

    @Override
    public Collection<String> keys() {
        Set keys = RedisHandler.getRedisTemplate().keys((Object)this.keyPattern);
        return new ArrayList<String>(keys);
    }

    @Override
    public int size() {
        return this.keys().size();
    }

    @Override
    public void clear() {
        RedisHandler.getRedisTemplate().delete(this.keys());
    }

    @Override
    public boolean exists(String key) {
        if (Strings.isNullOrEmpty((String)key)) {
            return false;
        }
        String fullKey = RedisKey.fullKey(this.group, key);
        return RedisHandler.getRedisTemplate().hasKey((Object)fullKey);
    }

    @Override
    public V get(String key) {
        String fullKey = RedisKey.fullKey(this.group, key);
        Object obj = RedisHandler.getRedisTemplate().opsForValue().get((Object)fullKey);
        if (obj == null) {
            return null;
        }
        return (V)((Cacheable)obj);
    }

    @Override
    public V put(String key, V object) {
        String fullKey = RedisKey.fullKey(this.group, key);
        RedisHandler.getRedisTemplate().opsForValue().set((Object)fullKey, object);
        return object;
    }

    @Override
    public V put(String key, V object, int timeout) {
        String fullKey = RedisKey.fullKey(this.group, key);
        RedisHandler.getRedisTemplate().opsForValue().set((Object)fullKey, object, (long)timeout, TimeUnit.SECONDS);
        return object;
    }

    @Override
    public boolean remove(String key) {
        if (Strings.isNullOrEmpty((String)key)) {
            return false;
        }
        String fullKey = RedisKey.fullKey(this.group, key);
        RedisHandler.getRedisTemplate().delete((Object)fullKey);
        return true;
    }

    @Override
    public V lookup(Lookup<V> lookup) {
        Collection<String> keys = this.keys();
        for (String key : keys) {
            Object obj = RedisHandler.getRedisTemplate().opsForValue().get((Object)key);
            if (obj == null || !lookup.isYou(key, (Cacheable)obj)) continue;
            return (V)((Cacheable)obj);
        }
        return null;
    }

    @Override
    public List<V> lookupAll(Lookup<V> lookup) {
        Collection<String> keys = this.keys();
        ArrayList result = Lists.newArrayList();
        for (String key : keys) {
            Object obj = RedisHandler.getRedisTemplate().opsForValue().get((Object)key);
            if (obj == null || !lookup.isYou(key, (Cacheable)obj)) continue;
            result.add((Cacheable)obj);
        }
        return result;
    }

    @Override
    public String lock(String key, long timeout, boolean noWait) {
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkArgument((timeout > 0L ? 1 : 0) != 0);
        String fullKey = RedisKey.fullKey(this.group, key) + "__lock";
        String identifier = UUID.randomUUID().toString();
        long lastTtl = -1L;
        while (true) {
            if (RedisHandler.getRedisTemplate().opsForValue().setIfAbsent((Object)fullKey, (Object)identifier).booleanValue()) break;
            long ttl = RedisHandler.getRedisTemplate().getExpire((Object)fullKey, TimeUnit.MILLISECONDS);
            if (ttl == -1L) {
                RedisHandler.getRedisTemplate().expire((Object)fullKey, timeout, TimeUnit.MILLISECONDS);
            } else {
                if (ttl == -2L) continue;
                if (lastTtl > 0L && ttl > lastTtl) {
                    return null;
                }
                lastTtl = ttl;
            }
            if (noWait) {
                return null;
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        RedisHandler.getRedisTemplate().expire((Object)fullKey, timeout, TimeUnit.MILLISECONDS);
        return identifier;
    }

    @Override
    public boolean unlock(String key, String identifier) {
        block1: {
            SessionCallback<Object> sessionCallback;
            Object results;
            Preconditions.checkNotNull((Object)key);
            Preconditions.checkNotNull((Object)identifier);
            final String fullKey = RedisKey.fullKey(this.group, key) + "__lock";
            do {
                RedisHandler.getRedisTemplate().watch((Object)fullKey);
                Object obj = RedisHandler.getRedisTemplate().opsForValue().get((Object)fullKey);
                if (obj == null || !identifier.equals(obj)) break block1;
                sessionCallback = new SessionCallback<Object>(){

                    public Object execute(RedisOperations operations) throws DataAccessException {
                        operations.multi();
                        operations.delete((Object)fullKey);
                        return operations.exec();
                    }
                };
            } while ((results = RedisHandler.getRedisTemplate().execute((SessionCallback)sessionCallback)) == null);
            return true;
        }
        RedisHandler.getRedisTemplate().unwatch();
        return false;
    }
}

