/*
 * Decompiled with CFR 0.152.
 */
package io.github.rcarlosdasilva.weixin.core.cache.storage.redis;

import io.github.rcarlosdasilva.weixin.core.Registry;
import io.github.rcarlosdasilva.weixin.core.exception.RedisCacheNotInitializeException;
import io.github.rcarlosdasilva.weixin.core.setting.RedisSetting;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.data.redis.core.RedisTemplate;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

public class RedisHandler {
    private static RedisTemplate redisTemplate = null;
    private static JedisPool pool = null;

    private RedisHandler() {
        throw new IllegalStateException("RedisHandler class");
    }

    public static RedisTemplate getRedisTemplate() {
        return redisTemplate;
    }

    public static void setRedisTemplate(RedisTemplate redisTemplate) {
        RedisHandler.redisTemplate = redisTemplate;
    }

    private static synchronized void initSimpleRedis(RedisSetting redisSetting) {
        pool = new JedisPool((GenericObjectPoolConfig)redisSetting.getConfig(), redisSetting.getHost(), redisSetting.getPort(), redisSetting.getTimeout(), redisSetting.getPassword(), redisSetting.getDatabase(), redisSetting.isUseSsl());
    }

    public static synchronized Jedis getJedis() {
        if (pool == null) {
            RedisSetting redisSetting = Registry.setting().getRedisSetting();
            if (redisSetting == null) {
                throw new RedisCacheNotInitializeException("Simple Redis\u7f13\u5b58\u672a\u914d\u7f6e");
            }
            RedisHandler.initSimpleRedis(redisSetting);
        }
        return pool.getResource();
    }
}

