/*
 * Decompiled with CFR 0.152.
 */
package io.github.rcarlosdasilva.weixin.core.cache.storage.redis;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class RedisKey {
    private static final Joiner JOINER = Joiner.on((String)":");
    private static final Splitter SPLITTER = Splitter.on((String)":");

    private RedisKey() {
        throw new IllegalStateException("RedisKey class");
    }

    public static String fullKey(String group, String shortKey) {
        return JOINER.join((Object)"weixin", (Object)group, new Object[]{shortKey});
    }

    public static String shortKey(String fullKey) {
        List parts;
        if (!Strings.isNullOrEmpty((String)fullKey) && (parts = SPLITTER.splitToList((CharSequence)fullKey)) != null && !parts.isEmpty()) {
            return (String)parts.get(parts.size() - 1);
        }
        return "";
    }

    public static Collection<String> shortKeys(Collection<String> redisKeys) {
        if (redisKeys == null) {
            return Collections.emptyList();
        }
        return Collections2.transform(redisKeys, (Function)new Function<String, String>(){

            public String apply(String input) {
                return RedisKey.shortKey(input);
            }
        });
    }
}

