/*
 * Decompiled with CFR 0.152.
 */
package io.github.rcarlosdasilva.weixin.core.encryption;

import com.google.common.base.Preconditions;
import io.github.rcarlosdasilva.weixin.core.encryption.ByteGroup;
import io.github.rcarlosdasilva.weixin.core.encryption.Pkcs7Encoder;
import io.github.rcarlosdasilva.weixin.core.parser.NotificationParser;
import io.github.rcarlosdasilva.weixin.model.notification.Notification;
import io.github.rcarlosdasilva.weixin.model.notification.NotificationResponseEncrypted;
import java.nio.charset.Charset;
import java.security.Key;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Encryptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(Encryptor.class);
    private static final int RANDOM_START = 47;
    private static final int RANDOM_END = 123;
    private static final int RANDOM_GAP = 76;
    private static final Random RANDOM = new Random();
    private static final Charset CHARSET = Charset.forName("utf-8");
    private static final Base64 BASE64 = new Base64();

    private Encryptor() {
    }

    public static String encrypt(String appid, String token, String key, String originalContent) {
        Preconditions.checkNotNull((Object)appid);
        Preconditions.checkNotNull((Object)token);
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkNotNull((Object)originalContent);
        String ciphertext = "";
        String annex = Encryptor.random(16);
        byte[] aesKey = Base64.decodeBase64((String)(key + "="));
        ByteGroup byteCollector = new ByteGroup();
        byte[] annexBytes = annex.getBytes(CHARSET);
        byte[] contentBytes = originalContent.getBytes(CHARSET);
        byte[] networkBytesOrder = Encryptor.getNetworkBytesOrder(contentBytes.length);
        byte[] appidBytes = appid.getBytes(CHARSET);
        byteCollector.addBytes(annexBytes);
        byteCollector.addBytes(networkBytesOrder);
        byteCollector.addBytes(contentBytes);
        byteCollector.addBytes(appidBytes);
        byte[] padBytes = Pkcs7Encoder.encode(byteCollector.size());
        byteCollector.addBytes(padBytes);
        byte[] unencrypted = byteCollector.toBytes();
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
            SecretKeySpec keySpec = new SecretKeySpec(aesKey, "AES");
            IvParameterSpec iv = new IvParameterSpec(aesKey, 0, 16);
            cipher.init(1, (Key)keySpec, iv);
            byte[] encrypted = cipher.doFinal(unencrypted);
            ciphertext = BASE64.encodeToString(encrypted);
        }
        catch (Exception ex) {
            LOGGER.error("weixin encryptor", (Throwable)ex);
            return null;
        }
        long timestamp = Calendar.getInstance().getTimeInMillis();
        String nonce = Encryptor.random(16);
        String signature = Encryptor.sha1(Encryptor.tidy(token, timestamp, nonce, ciphertext));
        NotificationResponseEncrypted responseEncrypted = new NotificationResponseEncrypted(ciphertext, signature, timestamp, nonce);
        return NotificationParser.toXml(responseEncrypted);
    }

    public static Notification decrypt(String token, String key, String ciphertext, String signature, long timestamp, String nonce) {
        byte[] original;
        Preconditions.checkNotNull((Object)token);
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkNotNull((Object)ciphertext);
        Preconditions.checkNotNull((Object)signature);
        Preconditions.checkNotNull((Object)nonce);
        String resignature = Encryptor.sha1(Encryptor.tidy(token, timestamp, nonce, ciphertext));
        if (!signature.equals(resignature)) {
            return null;
        }
        byte[] aesKey = Base64.decodeBase64((String)(key + "="));
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
            SecretKeySpec keySpec = new SecretKeySpec(aesKey, "AES");
            IvParameterSpec iv = new IvParameterSpec(Arrays.copyOfRange(aesKey, 0, 16));
            cipher.init(2, (Key)keySpec, iv);
            byte[] encrypted = Base64.decodeBase64((String)ciphertext);
            original = cipher.doFinal(encrypted);
        }
        catch (Exception ex) {
            LOGGER.error("weixin encryptor", (Throwable)ex);
            return null;
        }
        Notification notification = null;
        String originalContent = null;
        String appId = null;
        try {
            byte[] bytes = Pkcs7Encoder.decode(original);
            byte[] networkOrder = Arrays.copyOfRange(bytes, 16, 20);
            int xmlLength = Encryptor.recoverNetworkBytesOrder(networkOrder);
            originalContent = new String(Arrays.copyOfRange(bytes, 20, 20 + xmlLength), CHARSET);
            appId = new String(Arrays.copyOfRange(bytes, 20 + xmlLength, bytes.length), CHARSET);
            notification = NotificationParser.parse(originalContent);
            notification.setAppId(appId);
        }
        catch (Exception ex) {
            LOGGER.debug("weixin encryptor", (Throwable)ex);
            notification = new Notification();
            notification.setAppId(appId);
            notification.setPlaintext(originalContent);
        }
        return notification;
    }

    private static byte[] getNetworkBytesOrder(int sourceNumber) {
        byte[] orderBytes = new byte[4];
        orderBytes[3] = (byte)(sourceNumber & 0xFF);
        orderBytes[2] = (byte)(sourceNumber >> 8 & 0xFF);
        orderBytes[1] = (byte)(sourceNumber >> 16 & 0xFF);
        orderBytes[0] = (byte)(sourceNumber >> 24 & 0xFF);
        return orderBytes;
    }

    private static int recoverNetworkBytesOrder(byte[] orderBytes) {
        int sourceNumber = 0;
        for (int i = 0; i < 4; ++i) {
            sourceNumber <<= 8;
            sourceNumber |= orderBytes[i] & 0xFF;
        }
        return sourceNumber;
    }

    private static String random(int count) {
        Preconditions.checkArgument((count > 0 ? 1 : 0) != 0);
        char[] buffer = new char[count];
        while (count-- != 0) {
            char ch = (char)(RANDOM.nextInt(76) + 47);
            if (ch >= '0' && ch <= '9' || ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z') {
                buffer[count] = ch;
                continue;
            }
            ++count;
        }
        return new String(buffer);
    }

    private static String sha1(String raw) {
        return DigestUtils.sha1Hex((String)raw);
    }

    private static String tidy(String token, long timestamp, String nonce, String ciphertext) {
        Object[] params = new String[]{token, String.valueOf(timestamp), nonce, ciphertext};
        StringBuffer raw = new StringBuffer();
        Arrays.sort(params);
        for (int i = 0; i < 4; ++i) {
            raw.append((String)params[i]);
        }
        return raw.toString();
    }
}

