/*
 * Decompiled with CFR 0.152.
 */
package io.github.rcarlosdasilva.weixin.core.encryption;

import java.nio.charset.Charset;
import java.util.Arrays;

class Pkcs7Encoder {
    private static final Charset CHARSET = Charset.forName("utf-8");
    private static final int BLOCK_SIZE = 32;

    private Pkcs7Encoder() {
        throw new IllegalStateException("Pkcs7Encoder class");
    }

    static byte[] encode(int count) {
        int amountToPad = 32 - count % 32;
        if (amountToPad == 0) {
            amountToPad = 32;
        }
        char padChr = Pkcs7Encoder.charOf(amountToPad);
        StringBuilder tmp = new StringBuilder();
        for (int index = 0; index < amountToPad; ++index) {
            tmp.append(padChr);
        }
        return tmp.toString().getBytes(CHARSET);
    }

    static byte[] decode(byte[] decrypted) {
        byte pad = decrypted[decrypted.length - 1];
        if (pad < 1 || pad > 32) {
            pad = 0;
        }
        return Arrays.copyOfRange(decrypted, 0, decrypted.length - pad);
    }

    static char charOf(int number) {
        byte target = (byte)(number & 0xFF);
        return (char)target;
    }
}

