/*
 * Decompiled with CFR 0.152.
 */
package io.github.rcarlosdasilva.weixin.core.handler;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.github.rcarlosdasilva.weixin.common.dictionary.NotificationEventType;
import io.github.rcarlosdasilva.weixin.common.dictionary.NotificationInfoType;
import io.github.rcarlosdasilva.weixin.common.dictionary.NotificationMessageType;
import io.github.rcarlosdasilva.weixin.core.OpenPlatform;
import io.github.rcarlosdasilva.weixin.core.Registry;
import io.github.rcarlosdasilva.weixin.core.cache.CacheHandler;
import io.github.rcarlosdasilva.weixin.core.cache.GeneralCacheableObject;
import io.github.rcarlosdasilva.weixin.core.encryption.Encryptor;
import io.github.rcarlosdasilva.weixin.core.exception.CanNotFetchOpenPlatformLiceningInformationException;
import io.github.rcarlosdasilva.weixin.core.exception.CanNotFetchOpenPlatformLicenseException;
import io.github.rcarlosdasilva.weixin.core.exception.CanNotFetchOpenPlatformLicensorAccessTokenException;
import io.github.rcarlosdasilva.weixin.core.exception.CanNotFetchOpenPlatformTicketException;
import io.github.rcarlosdasilva.weixin.core.exception.WeirdWeixinNotificationException;
import io.github.rcarlosdasilva.weixin.core.handler.NotificationHandler;
import io.github.rcarlosdasilva.weixin.core.parser.NotificationParser;
import io.github.rcarlosdasilva.weixin.model.AccessToken;
import io.github.rcarlosdasilva.weixin.model.OpAccount;
import io.github.rcarlosdasilva.weixin.model.WeixinAccount;
import io.github.rcarlosdasilva.weixin.model.builder.Builder;
import io.github.rcarlosdasilva.weixin.model.builder.NotificationResponseBuilder;
import io.github.rcarlosdasilva.weixin.model.notification.Event;
import io.github.rcarlosdasilva.weixin.model.notification.Message;
import io.github.rcarlosdasilva.weixin.model.notification.Notification;
import io.github.rcarlosdasilva.weixin.model.notification.NotificationResponsePlaintext;
import io.github.rcarlosdasilva.weixin.model.notification.OpenInfo;
import io.github.rcarlosdasilva.weixin.model.response.open.auth.OpenPlatformAuthGetLicenseInformationResponse;
import io.github.rcarlosdasilva.weixin.model.response.open.auth.bean.LicensedAccessToken;
import io.github.rcarlosdasilva.weixin.model.response.open.auth.bean.LicensingInformation;
import io.github.rcarlosdasilva.weixin.model.response.open.auth.bean.LicensorInfromation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationHandlerProxy {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static NotificationHandlerProxy instance = null;
    private NotificationHandler handler;

    private NotificationHandlerProxy(NotificationHandler handler) {
        Preconditions.checkNotNull((Object)handler);
        this.handler = handler;
    }

    public static void proxy(NotificationHandler handler) {
        instance = new NotificationHandlerProxy(handler);
    }

    public static NotificationHandlerProxy instance() {
        Preconditions.checkNotNull((Object)instance);
        return instance;
    }

    public String process(String content) {
        return this.process(content, null, -1L, null);
    }

    public String process(String content, String signature, long timestamp, String nonce) {
        return this.process(null, content, signature, timestamp, nonce);
    }

    public String process(String appId, String content, String signature, long timestamp, String nonce) {
        String recipient;
        this.logger.debug("\u6b63\u5728\u5904\u7406\u5fae\u4fe1\u901a\u77e5: at {} --- {} || \u7b7e\u540d[{}] || \u968f\u673a\u7801[{}]", new Object[]{timestamp, content, signature, nonce});
        Notification notification = NotificationParser.parse(content);
        if (notification == null) {
            this.logger.warn("\u65e0\u6cd5\u89e3\u6790\u63a8\u9001\u5185\u5bb9: {}", (Object)content);
            return null;
        }
        String authorizingAppId = notification.getAppId();
        String normalAppId = appId == null ? notification.getToUser() : appId;
        String string = recipient = Strings.isNullOrEmpty((String)authorizingAppId) ? normalAppId : authorizingAppId;
        if (Strings.isNullOrEmpty((String)recipient)) {
            this.logger.warn("\u83b7\u53d6\u4e0d\u5230appid\u6216tousername\uff1a{}", (Object)content);
            if (Registry.setting().isThrowException()) {
                throw new WeirdWeixinNotificationException();
            }
        }
        if ((notification = this.decryptNotification(notification, recipient, signature, timestamp, nonce)) == null) {
            return null;
        }
        NotificationMessageType messageType = notification.getMessageType();
        NotificationInfoType infoType = notification.getInfoType();
        NotificationResponseBuilder builder = Builder.buildNotificationResponse().with(notification);
        if (messageType != null) {
            if (messageType == NotificationMessageType.EVENT) {
                this.logger.debug("\u5f00\u59cb\u5904\u7406\u4e8b\u4ef6\u63a8\u9001..");
                this.processEvent(builder, notification);
            } else {
                this.logger.debug("\u5f00\u59cb\u5904\u7406\u6d88\u606f\u63a8\u9001..");
                this.processMessage(builder, notification);
            }
        }
        if (infoType != null) {
            this.processInfo(infoType, builder, notification);
        }
        return this.encryptNotification(builder, notification.getAccount());
    }

    private Notification decryptNotification(Notification originalNotification, String recipient, String signature, long timestamp, String nonce) {
        OpAccount openPlatform = Registry.openPlatform();
        WeixinAccount account = Registry.lookup(recipient);
        if (openPlatform == null && account == null) {
            this.logger.warn("\u6ca1\u6709\u914d\u7f6e\u5f00\u653e\u5e73\u53f0\uff0c\u5e76\u4e14\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u516c\u4f17\u53f7\u914d\u7f6e(Account): {}", (Object)recipient);
            return null;
        }
        Notification decryptedNotification = null;
        if (account == null) {
            this.logger.debug("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u516c\u4f17\u53f7\u914d\u7f6e(Account): {}\uff0c\u8fd9\u662f\u4e00\u4e2a\u65b0\u7684\u516c\u4f17\u53f7\uff0c\u6b63\u5728\u4f7f\u7528\u5f00\u653e\u5e73\u53f0\u914d\u7f6e\u89e3\u5bc6..", (Object)recipient);
            decryptedNotification = Encryptor.decrypt(openPlatform.getAesToken(), openPlatform.getAesKey(), originalNotification.getCiphertext(), signature, timestamp, nonce);
        } else if (account.isWithOpenPlatform()) {
            if (openPlatform == null) {
                this.logger.warn("\u6ca1\u6709\u914d\u7f6e\u5f00\u653e\u5e73\u53f0\uff0c\u4f46\u516c\u4f17\u53f7\u914d\u7f6e(Account): {} \u4e3a\u5f00\u653e\u5e73\u53f0\u6388\u6743", (Object)recipient);
                return null;
            }
            this.logger.debug("\u6b63\u5728\u4f7f\u7528\u5f00\u653e\u5e73\u53f0\u914d\u7f6e\u5bf9\u516c\u4f17\u53f7(Account): {} \u89e3\u5bc6..", (Object)recipient);
            decryptedNotification = Encryptor.decrypt(openPlatform.getAesToken(), openPlatform.getAesKey(), originalNotification.getCiphertext(), signature, timestamp, nonce);
        } else if (account.isSafeMode()) {
            this.logger.debug("\u6b63\u5728\u4f7f\u7528\u516c\u4f17\u53f7\u914d\u7f6e(Account): {} \u89e3\u5bc6..", (Object)recipient);
            decryptedNotification = Encryptor.decrypt(account.getAesToken(), account.getAesKey(), originalNotification.getCiphertext(), signature, timestamp, nonce);
        } else {
            this.logger.debug("\u68c0\u6d4b\u5230\u516c\u4f17\u53f7\u914d\u7f6e(Account): {} \u4e3a\u660e\u6587\u6a21\u5f0f\uff0c\u4e0d\u9700\u8981\u89e3\u5bc6", (Object)recipient);
            return originalNotification;
        }
        if (decryptedNotification == null) {
            this.logger.warn("\u65e0\u6cd5\u89e3\u5bc6\uff0c\u6216\u89e3\u5bc6\u5931\u8d25: {}", (Object)recipient);
            return null;
        }
        this.logger.debug("\u89e3\u5bc6\u6210\u529f");
        decryptedNotification.setAccount(account);
        return decryptedNotification;
    }

    private String encryptNotification(NotificationResponseBuilder builder, WeixinAccount account) {
        NotificationResponsePlaintext response = builder.build();
        this.logger.debug("\u5904\u7406\u5b8c\u6bd5\uff0c\u5df2\u751f\u6210\u8fd4\u56de\u6570\u636e");
        if (response == null) {
            return "success";
        }
        OpAccount openPlatform = Registry.openPlatform();
        String reply = NotificationParser.toXml(response);
        if (account == null || account.isWithOpenPlatform()) {
            this.logger.debug("\u6b63\u5728\u4f7f\u7528\u5f00\u653e\u5e73\u53f0\u914d\u7f6e\u52a0\u5bc6..");
            reply = Encryptor.encrypt(openPlatform.getAppId(), openPlatform.getAesToken(), openPlatform.getAesKey(), reply);
            if (Strings.isNullOrEmpty((String)reply)) {
                this.logger.error("\u65e0\u6cd5\u52a0\u5bc6\uff1a{}", (Object)account);
                return null;
            }
            this.logger.debug("\u52a0\u5bc6\u6210\u529f");
        } else {
            this.logger.debug("\u6b63\u5728\u4f7f\u7528\u516c\u4f17\u53f7\u914d\u7f6e(Account): {} \u52a0\u5bc6..", (Object)account.getAppId());
            reply = Encryptor.encrypt(account.getAppId(), account.getAesToken(), account.getAesKey(), reply);
        }
        return reply;
    }

    public boolean isOpenPlatformActive(Notification notification) {
        return Registry.openPlatform() != null && !Strings.isNullOrEmpty((String)notification.getAppId());
    }

    private void processEvent(NotificationResponseBuilder builder, Notification notification) {
        Event event = notification.getEvent();
        NotificationEventType type = event.getType();
        switch (type) {
            case CLICK: {
                this.handler.doEventOfMenuForClick(builder, notification, event.getKey());
                break;
            }
            case VIEW: {
                this.handler.doEventOfMenuForView(builder, notification, event.getKey(), event.getMenuId());
                break;
            }
            case SCAN_QR_PUSH: {
                this.handler.doEventOfMenuForScanQrPush(builder, notification, event.getKey(), event.getScanCodeInfo());
                break;
            }
            case SCAN_QR_WAIT_MSG: {
                this.handler.doEventOfMenuForScanQrWait(builder, notification, event.getKey(), event.getScanCodeInfo());
                break;
            }
            case PIC_PHOTO: {
                this.handler.doEventOfMenuForPicPhoto(builder, notification, event.getKey(), event.getPicsInfo());
                break;
            }
            case PIC_PHOTO_OR_ALBUM: {
                this.handler.doEventOfMenuForPicPhotoOrAlbum(builder, notification, event.getKey(), event.getPicsInfo());
                break;
            }
            case PIC_WX_ALBUM: {
                this.handler.doEventOfMenuForPicWxAlbum(builder, notification, event.getKey(), event.getPicsInfo());
                break;
            }
            case LOCATION: {
                this.handler.doEventOfMenuForLocation(builder, notification, event.getKey(), event.getLocationInfo());
                break;
            }
            case MASS_SEND_FINISH: {
                this.handler.doEventOfMessageForMass(builder, notification, event.getMessageId(), event.getStatus(), event.getTotalCount(), event.getFilterCount(), event.getSentCount(), event.getErrorCount());
                break;
            }
            case TEMPLATE_SEND_FINISH: {
                this.handler.doEventOfMessageForTemplate(builder, notification, event.getMessageId(), event.getStatus());
                break;
            }
            case SUBSCRIBE: {
                this.handler.doEventOfCommonForSubscribe(builder, notification, event.getKey(), event.getTicket());
                break;
            }
            case UNSUBSCRIBE: {
                this.handler.doEventOfCommonForUnsubscribe(builder, notification);
                break;
            }
            case SCAN: {
                this.handler.doEventOfCommonForScanQr(builder, notification, event.getKey(), event.getTicket());
                break;
            }
            case REPORT_LOCATION: {
                this.handler.doEventOfCommonForLocation(builder, notification, event.getLatitude(), event.getLongitude(), event.getPrecision());
                break;
            }
            case VERIFY_QUALIFICATION_SUCCESS: {
                this.handler.doEventOfVerifyForQualificationSuccess(builder, notification, event.getExpiredTime());
                break;
            }
            case VERIFY_QUALIFICATION_FAIL: {
                this.handler.doEventOfVerifyForQualificationFail(builder, notification, event.getFailTime(), event.getFailReason());
                break;
            }
            case VERIFY_NAMING_SUCCESS: {
                this.handler.doEventOfVerifyForNamingSuccess(builder, notification, event.getExpiredTime());
                break;
            }
            case VERIFY_NAMING_FAIL: {
                this.handler.doEventOfVerifyForNamingFail(builder, notification, event.getFailTime(), event.getFailReason());
                break;
            }
            case VERIFY_ANNUAL: {
                this.handler.doEventOfVerifyForAnnual(builder, notification, event.getExpiredTime());
                break;
            }
            case VERIFY_EXPIRED: {
                this.handler.doEventOfVerifyForExpired(builder, notification, event.getExpiredTime());
                break;
            }
        }
    }

    private void processMessage(NotificationResponseBuilder builder, Notification notification) {
        NotificationMessageType type = notification.getMessageType();
        Message message = notification.getMessage();
        switch (type) {
            case TEXT: {
                this.handler.doMessageForText(builder, notification, message.getMessageId(), message.getContent());
                break;
            }
            case IMAGE: {
                this.handler.doMessageForImage(builder, notification, message.getMessageId(), message.getMediaId(), message.getPicUrl());
                break;
            }
            case VOICE: {
                this.handler.doMessageForVoice(builder, notification, message.getMessageId(), message.getMediaId(), message.getFormat(), message.getRecognition());
                break;
            }
            case VIDEO: {
                this.handler.doMessageForVideo(builder, notification, message.getMessageId(), message.getMediaId(), message.getMediaThumbId());
                break;
            }
            case SHORT_VIDEO: {
                this.handler.doMessageForShortVideo(builder, notification, message.getMessageId(), message.getMediaId(), message.getMediaThumbId());
                break;
            }
            case LOCATION: {
                this.handler.doMessageForLocation(builder, notification, message.getMessageId(), message.getLocationX(), message.getLocationY(), message.getScale(), message.getAddress());
                break;
            }
            case LINK: {
                this.handler.doMessageForLink(builder, notification, message.getMessageId(), message.getTitle(), message.getDescription(), message.getUrl());
                break;
            }
        }
    }

    private void processInfo(NotificationInfoType infoType, NotificationResponseBuilder builder, Notification notification) {
        OpenInfo info = notification.getOpenInfo();
        switch (infoType) {
            case VERIFY_TICKET: {
                this.processInfoWithVerifyTicket(info, builder, notification);
                break;
            }
            case AUTHORIZE_SUCCEEDED: {
                this.processInfoWhenSuccessed(info, builder, notification);
                break;
            }
            case AUTHORIZE_CANCELED: {
                this.processInfoWhenCanceled(info, builder, notification);
                break;
            }
            case AUTHORIZE_UPDATED: {
                this.processInfoWhenUpdated(info, builder, notification);
                break;
            }
        }
    }

    private void processInfoWithVerifyTicket(OpenInfo info, NotificationResponseBuilder builder, Notification notification) {
        String ticket = notification.getOpenInfo().getTicket();
        if (Strings.isNullOrEmpty((String)ticket)) {
            this.logger.warn("\u65e0\u6cd5\u83b7\u53d6\u5230\u5f00\u653e\u5e73\u53f0\u53d1\u653e\u7684Ticket");
            throw new CanNotFetchOpenPlatformTicketException();
        }
        CacheHandler.of(GeneralCacheableObject.class).put("op_ticket", new GeneralCacheableObject(ticket));
        this.handler.doInfoOfComponentVerifyTicket(builder, notification, info.getTicket());
    }

    private void processInfoWhenSuccessed(OpenInfo info, NotificationResponseBuilder builder, Notification notification) {
        WeixinAccount account;
        boolean autoLoad = Registry.setting().isAutoLoadAuthorizedWeixinData();
        LicensingInformation licensingInformation = null;
        LicensorInfromation licensorInfromation = null;
        LicensedAccessToken accessToken = null;
        if (autoLoad) {
            OpenPlatformAuthGetLicenseInformationResponse licensingInformationResponse = this.fetchLicensingInformation(info.getLicense());
            OpenPlatformAuthGetLicenseInformationResponse licensorInformationResponse = this.fetchLicensorInformation(info.getLicensorAppId());
            accessToken = licensingInformationResponse.getLicensedAccessToken();
            licensingInformation = licensingInformationResponse.getLicensingInformation();
            licensorInfromation = licensorInformationResponse.getLicensorInfromation();
        }
        if ((account = this.handler.doInfoOfAuthorizeSucceeded(builder, notification, info.getLicensorAppId(), info.getLicense(), info.getLicenseExpireAt(), accessToken, licensingInformation, licensorInfromation)) != null) {
            Registry.update(account);
            if (accessToken != null) {
                accessToken.setAccountMark(account.getKey());
                CacheHandler.of(AccessToken.class).put(account.getKey(), accessToken);
            }
        }
    }

    private void processInfoWhenCanceled(OpenInfo info, NotificationResponseBuilder builder, Notification notification) {
        String licensorAppId = notification.getOpenInfo().getLicensorAppId();
        if (Strings.isNullOrEmpty((String)licensorAppId)) {
            this.logger.warn("\u65e0\u6cd5\u83b7\u53d6\u5230\u5f00\u653e\u5e73\u53f0\u6388\u6743\u8005appid");
            throw new CanNotFetchOpenPlatformLicenseException();
        }
        Registry.remove(licensorAppId);
        this.handler.doInfoOfAuthorizeCanceled(builder, notification, info.getLicensorAppId());
    }

    private void processInfoWhenUpdated(OpenInfo info, NotificationResponseBuilder builder, Notification notification) {
        WeixinAccount account;
        boolean autoLoad = Registry.setting().isAutoLoadAuthorizedWeixinData();
        LicensingInformation licensingInformation = null;
        LicensorInfromation licensorInfromation = null;
        LicensedAccessToken accessToken = null;
        if (autoLoad) {
            OpenPlatformAuthGetLicenseInformationResponse licensingInformationResponse = this.fetchLicensingInformation(info.getLicense());
            OpenPlatformAuthGetLicenseInformationResponse licensorInformationResponse = this.fetchLicensorInformation(info.getLicensorAppId());
            accessToken = licensingInformationResponse.getLicensedAccessToken();
            licensingInformation = licensingInformationResponse.getLicensingInformation();
            licensorInfromation = licensorInformationResponse.getLicensorInfromation();
        }
        if ((account = this.handler.doInfoOfAuthorizeUpdated(builder, notification, info.getLicensorAppId(), info.getLicense(), info.getLicenseExpireAt(), accessToken, licensingInformation, licensorInfromation)) != null) {
            Registry.update(account);
            if (accessToken != null) {
                accessToken.setAccountMark(account.getKey());
                CacheHandler.of(AccessToken.class).put(account.getKey(), accessToken);
            }
        }
    }

    private OpenPlatformAuthGetLicenseInformationResponse fetchLicensingInformation(String license) {
        Preconditions.checkNotNull((Object)license);
        OpenPlatformAuthGetLicenseInformationResponse response = OpenPlatform.certificate().getLicensingInformation(license);
        if (response == null) {
            throw new CanNotFetchOpenPlatformLiceningInformationException();
        }
        if (response.getLicensedAccessToken() == null) {
            throw new CanNotFetchOpenPlatformLicensorAccessTokenException();
        }
        if (response.getLicensingInformation() == null) {
            throw new CanNotFetchOpenPlatformLicenseException();
        }
        return response;
    }

    private OpenPlatformAuthGetLicenseInformationResponse fetchLicensorInformation(String licensorAppId) {
        Preconditions.checkNotNull((Object)licensorAppId);
        OpenPlatformAuthGetLicenseInformationResponse response = OpenPlatform.certificate().getLicensorInformation(licensorAppId);
        if (response == null || response.getLicensorInfromation() == null) {
            this.logger.warn("\u65e0\u6cd5\u83b7\u53d6\u5230\u5f00\u653e\u5e73\u53f0\u6388\u6743\u65b9\u7684\u57fa\u672c\u4fe1\u606f\uff0c\u4f46\u4e0d\u5f71\u54cd\u4e3b\u8981\u529f\u80fd");
            throw new CanNotFetchOpenPlatformLicenseException();
        }
        return response;
    }
}

