/*
 * Decompiled with CFR 0.152.
 */
package io.github.rcarlosdasilva.weixin.core.http;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import io.github.rcarlosdasilva.weixin.core.exception.HttpException;
import io.github.rcarlosdasilva.weixin.core.http.ContentType;
import io.github.rcarlosdasilva.weixin.core.http.FormData;
import io.github.rcarlosdasilva.weixin.core.http.HttpMethod;
import io.github.rcarlosdasilva.weixin.core.http.MultiFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.TimeUnit;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Http {
    private static final Logger LOGGER = LoggerFactory.getLogger(Http.class);
    private static final OkHttpClient CLIENT = new OkHttpClient.Builder().connectTimeout(3L, TimeUnit.SECONDS).readTimeout(10L, TimeUnit.SECONDS).build();
    private static final MediaType JSON_TYPE = MediaType.parse((String)"application/json; charset=utf-8");
    private static final MediaType XML_TYPE = MediaType.parse((String)"application/xml; charset=utf-8");
    private static final MediaType MULTI_FORM_TYPE = MultipartBody.FORM;

    private Http() {
    }

    private static Request generatePlainRequest(String url, HttpMethod method, String content, ContentType type) {
        Request request;
        MediaType mediaType = type == ContentType.JSON ? JSON_TYPE : XML_TYPE;
        content = Strings.nullToEmpty((String)content);
        Request.Builder builder = new Request.Builder().url(url);
        switch (method) {
            case GET: {
                request = builder.build();
                break;
            }
            case HEAD: {
                request = builder.head().build();
                break;
            }
            case POST: {
                request = builder.post(RequestBody.create((MediaType)mediaType, (String)content)).build();
                break;
            }
            case PUT: {
                request = builder.put(RequestBody.create((MediaType)mediaType, (String)content)).build();
                break;
            }
            case PATCH: {
                request = builder.patch(RequestBody.create((MediaType)mediaType, (String)content)).build();
                break;
            }
            case DELETE: {
                request = builder.delete(RequestBody.create((MediaType)mediaType, (String)content)).build();
                break;
            }
            default: {
                request = null;
            }
        }
        if (request == null) {
            throw new HttpException("Unsupported or unknown request method");
        }
        return request;
    }

    private static Request generateFormRequest(String url, HttpMethod method, List<FormData> form) {
        Request request;
        Request.Builder builder = new Request.Builder().url(url);
        FormBody.Builder formBuilder = new FormBody.Builder();
        if (form != null) {
            for (FormData data : form) {
                formBuilder.add(data.getKey(), data.getValue());
            }
        }
        switch (method) {
            case POST: {
                request = builder.post((RequestBody)formBuilder.build()).build();
                break;
            }
            case PUT: {
                request = builder.put((RequestBody)formBuilder.build()).build();
                break;
            }
            case PATCH: {
                request = builder.patch((RequestBody)formBuilder.build()).build();
                break;
            }
            case DELETE: {
                request = builder.delete((RequestBody)formBuilder.build()).build();
                break;
            }
            default: {
                request = null;
            }
        }
        if (request == null) {
            throw new HttpException("Unsupported or unknown request method");
        }
        return request;
    }

    public static String requestWithBodyContent(String url, HttpMethod method, String content, ContentType type) {
        Request request = Http.generatePlainRequest(url, method, content, type);
        try {
            Response response = CLIENT.newCall(request).execute();
            if (!response.isSuccessful()) {
                throw new HttpException(response.message());
            }
            return response.body().string();
        }
        catch (IOException ex) {
            LOGGER.error("weixin http", (Throwable)ex);
            return "";
        }
    }

    public static InputStream requestStreamWithBodyContent(String url, HttpMethod method, String content, ContentType type) {
        Request request = Http.generatePlainRequest(url, method, content, type);
        try {
            Response response = CLIENT.newCall(request).execute();
            if (!response.isSuccessful()) {
                throw new HttpException(response.message());
            }
            return response.body().byteStream();
        }
        catch (IOException ex) {
            LOGGER.error("weixin http", (Throwable)ex);
            return null;
        }
    }

    public static String requestWithForm(String url, HttpMethod method, List<FormData> form) {
        Request request = Http.generateFormRequest(url, method, form);
        try {
            Response response = CLIENT.newCall(request).execute();
            if (!response.isSuccessful()) {
                throw new HttpException(response.message());
            }
            return response.body().string();
        }
        catch (IOException ex) {
            LOGGER.error("weixin http", (Throwable)ex);
            return "";
        }
    }

    public static InputStream requestStreamWithForm(String url, HttpMethod method, List<FormData> form) {
        Request request = Http.generateFormRequest(url, method, form);
        try {
            Response response = CLIENT.newCall(request).execute();
            if (!response.isSuccessful()) {
                throw new HttpException(response.message());
            }
            return response.body().byteStream();
        }
        catch (IOException ex) {
            LOGGER.error("weixin http", (Throwable)ex);
            return null;
        }
    }

    public static String requestWithFile(String url, MultiFile multiFile, List<FormData> additionalData) {
        return Http.requestWithFile(url, Lists.newArrayList((Object[])new MultiFile[]{multiFile}), additionalData);
    }

    public static String requestWithFile(String url, List<MultiFile> multiFiles, List<FormData> additionalData) {
        MultipartBody.Builder builder = new MultipartBody.Builder();
        builder.setType(MULTI_FORM_TYPE);
        if (additionalData != null) {
            for (FormData formData : additionalData) {
                builder.addFormDataPart(formData.getKey(), formData.getValue());
            }
        }
        for (MultiFile multiFile : multiFiles) {
            MediaType mediaType = MediaType.parse((String)multiFile.getContentType().getText());
            builder.addFormDataPart(multiFile.getFileKey(), multiFile.getFileName(), RequestBody.create((MediaType)mediaType, (File)multiFile.getFile()));
        }
        MultipartBody body = builder.build();
        Request request = new Request.Builder().url(url).post((RequestBody)body).build();
        try {
            Response response = CLIENT.newCall(request).execute();
            if (!response.isSuccessful()) {
                throw new HttpException(response.message());
            }
            return response.body().string();
        }
        catch (IOException ex) {
            LOGGER.error("weixin http", (Throwable)ex);
            return "";
        }
    }
}

