/*
 * Decompiled with CFR 0.152.
 */
package io.github.rcarlosdasilva.weixin.core.inspect;

import com.google.common.collect.Lists;
import io.github.lukehutch.fastclasspathscanner.FastClasspathScanner;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.ImplementingClassMatchProcessor;
import io.github.rcarlosdasilva.weixin.core.Registry;
import io.github.rcarlosdasilva.weixin.core.inspect.Inspector;
import io.github.rcarlosdasilva.weixin.core.inspect.ProblemObject;
import io.github.rcarlosdasilva.weixin.core.inspect.Worker;
import java.util.List;

public class InspectDispatcher
implements Runnable {
    private final long interval;
    private final List<Inspector> inspectors;
    private final List<Worker> workers;

    private InspectDispatcher() {
        String packageName = this.getClass().getPackage().getName();
        this.interval = Registry.setting().getInspectDispatchIntervalInMill();
        this.inspectors = Lists.newArrayList();
        this.workers = Lists.newArrayList();
        FastClasspathScanner fcs = new FastClasspathScanner(new String[]{packageName});
        fcs.matchClassesImplementing(Inspector.class, (ImplementingClassMatchProcessor)new ImplementingClassMatchProcessor<Inspector>(){

            public void processMatch(Class<? extends Inspector> implementingClass) {
                try {
                    InspectDispatcher.this.inspectors.add(implementingClass.newInstance());
                }
                catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                    // empty catch block
                }
            }
        });
        fcs.matchClassesImplementing(Worker.class, (ImplementingClassMatchProcessor)new ImplementingClassMatchProcessor<Worker>(){

            public void processMatch(Class<? extends Worker> implementingClass) {
                try {
                    InspectDispatcher.this.workers.add(implementingClass.newInstance());
                }
                catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                    // empty catch block
                }
            }
        });
        fcs.scan();
    }

    public static void main(String[] args) {
        InspectDispatcher.startup();
    }

    public static void startup() {
        new Thread(new InspectDispatcher()).start();
    }

    @Override
    public void run() {
        while (!Thread.currentThread().isInterrupted()) {
            for (Inspector inspector : this.inspectors) {
                ProblemObject<?> problem = inspector.inspect();
                if (problem == null) continue;
                for (Worker worker : this.workers) {
                    if (!worker.support(problem)) continue;
                    worker.doit(problem);
                }
            }
            try {
                Thread.sleep(this.interval);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
                Thread.currentThread().interrupt();
            }
        }
    }
}

