/*
 * Decompiled with CFR 0.152.
 */
package io.github.rcarlosdasilva.weixin.core.inspect.inspector;

import io.github.rcarlosdasilva.weixin.core.cache.CacheHandler;
import io.github.rcarlosdasilva.weixin.core.cache.Lookup;
import io.github.rcarlosdasilva.weixin.core.inspect.Inspector;
import io.github.rcarlosdasilva.weixin.core.inspect.ProblemObject;
import io.github.rcarlosdasilva.weixin.core.inspect.WorkSheet;
import io.github.rcarlosdasilva.weixin.model.AccessToken;
import java.util.List;

public class AccessTokenInspector
implements Inspector {
    private static final String MARK = AccessToken.class.getName();

    @Override
    public ProblemObject<?> inspect() {
        if (WorkSheet.isWorking(MARK)) {
            return null;
        }
        List<AccessToken> results = CacheHandler.of(AccessToken.class).lookupAll(new Lookup<AccessToken>(){

            @Override
            public boolean isYou(String key, AccessToken obj) {
                return obj.isExpired();
            }
        });
        if (results == null || results.isEmpty()) {
            return null;
        }
        ProblemObject<AccessToken> problem = new ProblemObject<AccessToken>(AccessToken.class, MARK);
        problem.setDefaultObjects(results);
        return problem;
    }
}

