/*
 * Decompiled with CFR 0.152.
 */
package io.github.rcarlosdasilva.weixin.core.inspect.worker;

import io.github.rcarlosdasilva.weixin.core.OpenPlatform;
import io.github.rcarlosdasilva.weixin.core.Weixin;
import io.github.rcarlosdasilva.weixin.core.inspect.ProblemObject;
import io.github.rcarlosdasilva.weixin.core.inspect.WorkSheet;
import io.github.rcarlosdasilva.weixin.core.inspect.Worker;
import io.github.rcarlosdasilva.weixin.model.AccessToken;
import java.util.Collection;

public class AcessTokenWorker
implements Worker<AccessToken> {
    @Override
    public boolean support(ProblemObject<AccessToken> problem) {
        return AccessToken.class == problem.getType();
    }

    @Override
    public void doit(final ProblemObject<AccessToken> problem) {
        if (WorkSheet.isWorking(problem.getMark())) {
            return;
        }
        WorkSheet.start(problem.getMark());
        new Thread(new Runnable(){

            @Override
            public void run() {
                Collection accessTokens = problem.getDefaultObjects();
                if (accessTokens != null && !accessTokens.isEmpty()) {
                    for (AccessToken accessToken : accessTokens) {
                        String key = accessToken.getAccountMark();
                        if ("op_access_token".equals(key)) {
                            OpenPlatform.certificate().askAccessToken();
                            continue;
                        }
                        Weixin.with(key).certificate().askAccessToken();
                    }
                }
                WorkSheet.done(problem.getMark());
            }
        }).start();
    }
}

