/*
 * Decompiled with CFR 0.152.
 */
package io.github.rcarlosdasilva.weixin.core.json;

import com.google.common.base.Preconditions;
import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import io.github.rcarlosdasilva.weixin.core.json.CustomTypeAdapterFactory;
import io.github.rcarlosdasilva.weixin.core.json.Freeze;

public final class Json {
    private static final Gson gson = new GsonBuilder().enableComplexMapKeySerialization().disableHtmlEscaping().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).registerTypeAdapterFactory((TypeAdapterFactory)new CustomTypeAdapterFactory()).addSerializationExclusionStrategy(new ExclusionStrategy(){

        public boolean shouldSkipField(FieldAttributes field) {
            Freeze anno = (Freeze)field.getAnnotation(Freeze.class);
            return anno != null;
        }

        public boolean shouldSkipClass(Class<?> clazz) {
            return false;
        }
    }).create();

    private Json() {
        throw new IllegalStateException("Json class");
    }

    public static <T> String toJson(Object obj, Class<T> clazz) {
        Preconditions.checkNotNull((Object)obj);
        return gson.toJson(obj, clazz);
    }

    public static <T> T fromJson(String json, Class<T> clazz) {
        Preconditions.checkNotNull((Object)json);
        return (T)gson.fromJson(json, clazz);
    }
}

